/** About getting and setting the values of Pimcore data components from JS code

* input, textarea, select, numeric, checkbox
	object.edit.dataFields.inputName.component.setValue(value)
* href
	this = object.edit.dataFields.inputName
	this.component.setValue(data.fullpath);
	this.data.id = data.id;
	this.data.type = data.type;
	this.data.subtype = data.subtype;
	this.dataChanged = true;
	
	OR to empty

	this = object.edit.dataFields.inputName
	this.component.setValue("");
	this.data = {}
	this.dataChanged = true;
* fieldcollections
	- add empty block element
		this = object.edit.dataFields.fieldCollectionName;
		this.addBlockElement(index, type) - e.g. 0, orderproduct
	- remove block element at a specific index
		this = object.edit.dataFields.fieldCollectionName;
		this.removeBlock(this.currentElements[index].container);
	- edit componenent inside a block (you need to know the index of the block and also the index of the component inside the block)
		block = object.edit.dataFields.fieldCollectionName.currentElements[blockIndex];
		block.fields[fieldIndex].component.setValue(); - setValue is the same as simple components
		TODO research if there is not a way to determine the component index
* not editabled components
	- the changes are not sent back to PHP, so you need to change it directly in PHP

*/

pimcore.registerNS("pimcore.plugin.backend");

pimcore.plugin.backend = Class.create(pimcore.plugin.admin, {
    getClassName: function() {
        return "pimcore.plugin.backend";
    },

    initialize: function() {
        pimcore.plugin.broker.registerPlugin(this);
		this.navEl = Ext.get('pimcore_menu_settings').insertSibling('<li id="pimcore_menu_eshop" class="pimcore_menu_item ">E&#8209;shop</li>');
    },
 
    pimcoreReady: function (params,broker){
		//CKE config for objects and documents
		pimcore.globalmanager.add('websiteEditorConfig', {
			entities: false,
			entities_greek: false,
			entities_latin: false,
			disableNativeSpellChecker: false,
			allowedContent: true, //this prevents CKE from removing pimcore attributes from elements
			enterMode: 1,
			toolbar: [
				{ name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' ] },
				{ name: 'links', items: [ 'Link', 'Unlink', 'Anchor' ] },
				{ name: 'insert', items: [ 'Image', 'Table', 'HorizontalRule', 'SpecialChar', 'Iframe' ] },
				{ name: 'tools', items: [ 'Sourcedialog' ] },
				'/',
				{ name: 'styles', items: [ 'Styles', 'Format' ] },
				{ name: 'align', items: [ 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] },
				{ name: 'basicstyles', items: [ 'Bold', 'Italic', 'Strike', '-', 'RemoveFormat' ] },
				{ name: 'paragraph', items: [ 'NumberedList', 'BulletedList' ] },
			],
			stylesSet: 'websiteEditorStyles:/plugins/Backend/static/js/cke_styles.js',
			format_tags: 'h1;h2;h3;h4;h5;h6;p',
			removeDialogTabs: 'image:Upload;table:advanced;iframe:advanced',
			ext: {
				dialogDefinitionCallback: function (ev) {
					var dialogName = ev.data.name;
					var dialogDefinition = ev.data.definition;
					var infoTab = null;
					var advancedTab = null;
					if (dialogName == 'link') {
						advancedTab = dialogDefinition.getContents('advanced');
						advancedTab.remove('advId');
						advancedTab.remove('advLangDir');
						advancedTab.remove('advAccessKey');
						advancedTab.remove('advName');
						advancedTab.remove('advLangCode');
						advancedTab.remove('advTabIndex');
						advancedTab.remove('advContentType');
						advancedTab.remove('advCSSClasses');
						advancedTab.remove('advCharset');
						advancedTab.remove('advRel');
						advancedTab.remove('advStyles');
					} else if (dialogName == 'image') {
						infoTab = dialogDefinition.getContents('info');
						advancedTab = dialogDefinition.getContents('advanced');
						
						infoTab.remove('txtBorder');
						infoTab.remove('txtHSpace');
						infoTab.remove('txtVSpace');
						infoTab.remove('cmbAlign');
						advancedTab.remove('linkId');
						advancedTab.remove('cmbLangDir');
						advancedTab.remove('txtLangCode');
						advancedTab.remove('txtGenLongDescr');
						advancedTab.remove('txtGenClass');
						advancedTab.remove('txtdlgGenStyle');
					} else if (dialogName == 'iframe') {
						infoTab = dialogDefinition.getContents('info');
						infoTab.remove('align');
						infoTab.remove('scrolling');
						infoTab.remove('name');
						infoTab.remove('title');
						infoTab.remove('longdesc');
					} else if (dialogName == 'table') {
						infoTab = dialogDefinition.getContents('info');
						infoTab.remove('txtWidth');
						infoTab.remove('txtHeight');
						infoTab.remove('txtBorder');
						infoTab.remove('txtCellSpace');
						infoTab.remove('txtCellPad');
						infoTab.remove('txtSummary');
						infoTab.remove('cmbAlign');
					}
				}
			}
		});
		CKEDITOR.dtd.$removeEmpty.i = 0;
		CKEDITOR.on('dialogDefinition', pimcore.globalmanager.get('websiteEditorConfig').ext.dialogDefinitionCallback);
		pimcore.object.tags.wysiwyg.defaultEditorConfig = pimcore.globalmanager.get('websiteEditorConfig');

		// turn off asset and document tree previews
		var assetTree = pimcore.globalmanager.get('layout_asset_tree');
		var documentTree = pimcore.globalmanager.get('layout_document_tree');
		if (assetTree) {
			if (assetTree.tree.events.itemmouseenter) {
				assetTree.tree.events.itemmouseenter.clearListeners();
			}
			if (assetTree.tree.events.itemmouseleave) {
				assetTree.tree.events.itemmouseleave.clearListeners();
			}
		}
		if (documentTree) {
			if (documentTree.tree.events.itemmouseenter) {
				documentTree.tree.events.itemmouseenter.clearListeners();
			}
			if (documentTree.tree.events.itemmouseleave) {
				documentTree.tree.events.itemmouseleave.clearListeners();
			}
		}

		//append eshop menu to main toolbar
		var eshopTree = pimcore.globalmanager.get('layout_object_tree_1');
		var ordersTree = pimcore.globalmanager.get('layout_object_tree_2');
		var varioExportForm = new Ext.FormPanel({
			bodyStyle:'padding:5px 5px 0',
			url: '/plugin/Backend/index/prepare-vario-export',
			items: [
				{
					id: "portlet-backend-vario-export-since",
					xtype:"datefield",
					name:"since",
					fieldLabel: t("plugin_backend_label_since"),
					format: "Y-m-d",
					submitFormat: 'Y-m-d',
					value: new Date(new Date().setDate(new Date().getDate() - 30)),
					allowBlank: true,
					triggerAction: "all"
				},
				{
					id: "portlet-backend-vario-export-until",
					xtype:"datefield",
					name:"until",
					fieldLabel: t("plugin_backend_label_until"),
					format: "Y-m-d",
					submitFormat: 'Y-m-d',
					value: new Date(new Date()),
					allowBlank: true,
					triggerAction: "all"
				},
				{
					id: "portlet-backend-vario-export-credit-notes",
					xtype:"checkbox",
					name:"credit-notes",
					fieldLabel: t("plugin_backend_label_export_credit_notes"),
					allowBlank: true,
					triggerAction: "all"
				}
			],
			buttons: [
				{
					text: t("plugin_backend_label_export"),
					handler: function() {
						pimcore.globalmanager.get("loadingmask").show();
						varioExportForm.getForm().submit({
							success: function(form, action) {
								var res = Ext.decode(action.response.responseText);
								if (res.count) {
									pimcore.helpers.download("/plugin/Backend/index/download-vario-export?credit-notes="+((res.creditNotes) ? 1 : 0));
								} else {
									Ext.MessageBox.alert(t("error"), t("plugin_backend_notice_vario_export_no_orders"));
								}
								pimcore.globalmanager.get("loadingmask").hide();
							},
							failure: function() {
								pimcore.globalmanager.get("loadingmask").hide();
								Ext.MessageBox.alert(t("error"), t("plugin_backend_error_generating_vario_export"));
							}
						});
					}
				},
				{
					text: t("plugin_backend_label_cancel"),
					handler: function() {
						Ext.getCmp('plugin_backend_vario_export_window').hide();
					}
				}
			]
		});
        var menu = new Ext.menu.Menu({
            items: [{
                text: t("plugin_backend_settings"),
                iconCls: "plugin_backend_icon_settings",
                handler: function () {
					pimcore.helpers.openObject(12, 'object', true);
				}
            },
			{
				text: t("plugin_backend_products"),
				iconCls: "plugin_backend_icon_products",
				handler: function() {
					Ext.getCmp("pimcore_panel_tree_customviews_1").expand();
					pimcore.helpers.selectPathInTree(eshopTree.tree, '/7/2', function() {
						eshopTree.refresh(eshopTree.tree.store.getNodeById(2));
					});
				}
			},
			{
				text: t("plugin_backend_orders"),
				iconCls: "plugin_backend_icon_orders",
				handler: function() {
					Ext.getCmp("pimcore_panel_tree_customviews_2").expand();
					pimcore.helpers.selectPathInTree(ordersTree.tree, '/10/8', function() {
						ordersTree.refresh(ordersTree.tree.store.getNodeById(8));
					});
				}
			},
			{
				text: t("plugin_backend_new_order"),
				iconCls: "plugin_backend_icon_order",
				handler: function() {
					pimcore.globalmanager.get("loadingmask").show();
					Ext.Ajax.request({
						url: '/plugin/Backend/index/create-new-order',
						success: function (response) {
							var res = Ext.decode(response.responseText);
							pimcore.globalmanager.get("loadingmask").hide();
							if (!res.status) {
								Ext.MessageBox.alert(t("error"), t("plugin_backend_error_new_order"));
							} else {
								pimcore.helpers.openObject(res.id, 'object', true);
							}
						},
						failure: function () {
							pimcore.globalmanager.get("loadingmask").hide();
							Ext.MessageBox.alert(t("error"), t("plugin_backend_error_new_order"));
						}
					});
				}
			},
			{
				text: t("plugin_backend_codes"),
				iconCls: "plugin_backend_icon_codes",
				handler: function() {
					Ext.getCmp("pimcore_panel_tree_customviews_1").expand();
					pimcore.helpers.selectPathInTree(eshopTree.tree, '/7/9', function() {
						eshopTree.refresh(eshopTree.tree.store.getNodeById(9));
					});
				}
			},
			{
				text: t("plugin_backend_promotions"),
				iconCls: "plugin_backend_icon_promotions",
				handler: function() {
					Ext.getCmp("pimcore_panel_tree_customviews_1").expand();
					pimcore.helpers.selectPathInTree(eshopTree.tree, '/7/11', function() {
						eshopTree.refresh(eshopTree.tree.store.getNodeById(11));
					});
				}
			},
			{
				text: t("plugin_backend_brands"),
				iconCls: "plugin_backend_icon_brands",
				handler: function() {
					Ext.getCmp("pimcore_panel_tree_customviews_1").expand();
					pimcore.helpers.selectPathInTree(eshopTree.tree, '/7/19', function() {
						eshopTree.refresh(eshopTree.tree.store.getNodeById(19));
					});
				}
			},
			{
				text: t("plugin_backend_variant_attributes"),
				iconCls: "plugin_backend_icon_variants",
            	hideOnClick: false,
				menu: {
                	cls: "pimcore_navigation_flyout",
					items: [{
						text: t("plugin_backend_colors"),
						iconCls: "plugin_backend_icon_colors",
						handler: function() {
							Ext.getCmp("pimcore_panel_tree_customviews_1").expand();
							pimcore.helpers.selectPathInTree(eshopTree.tree, '/7/16/17', function() {
								eshopTree.refresh(eshopTree.tree.store.getNodeById(17));
							});
						}
					},
					{
						text: t("plugin_backend_sizes"),
						iconCls: "plugin_backend_icon_sizes",
						handler: function() {
							Ext.getCmp("pimcore_panel_tree_customviews_1").expand();
							pimcore.helpers.selectPathInTree(eshopTree.tree, '/7/16/18', function() {
								eshopTree.refresh(eshopTree.tree.store.getNodeById(18));
							});
						}
					}]
				}
			},
			{
				text: t("plugin_backend_vario_export"),
				iconCls: "plugin_backend_icon_vario_export",
				handler: function() {
					var varioExportWindow = Ext.getCmp('plugin_backend_vario_export_window');
					if (varioExportWindow) {
						varioExportWindow.show();
					} else {
						new Ext.Window({
							id: 'plugin_backend_vario_export_window',
							layout: 'fit',
							width: 300,
							height: 220,
							modal: true,
							title: t("plugin_backend_vario_export"),
							closeAction: 'hide',
							items: [varioExportForm]
						}).show();
					}
				}
			},
			{
				text: t("plugin_backend_reindex_elastic"),
				iconCls: "pimcore_icon_clear_cache",
				handler: function() {
					Ext.Msg.confirm(t('warning'), t('plugin_backend_this_may_take_a_while'), function(btn){
						if (btn == 'yes'){
							pimcore.globalmanager.get("loadingmask").show();
							Ext.Ajax.request({
								url: '/plugin/Backend/index/reindex-elastic',
								success: function (response) {
									pimcore.globalmanager.get("loadingmask").hide();
								},
								failure: function () {
									pimcore.globalmanager.get("loadingmask").hide();
									Ext.MessageBox.alert(t("error"), t("plugin_backend_error_reindexing_elastic"));
								}
							});
						}
					});
				}
			}],
			cls: "pimcore_navigation_flyout"
        });
        var toolbar = pimcore.globalmanager.get("layout_toolbar");
        this.navEl.on("mousedown", toolbar.showSubMenu.bind(menu));

		//load currencies
        Ext.Ajax.request({
            url: "/plugin/Backend/index/disabled-currencies",
            success: function (response) {
                var res = Ext.decode(response.responseText);
				pimcore.settings.disabledCurrencies = res;
            }
        });

		// discounted price enabling/disabling
		// TODO - rewrite using extjs
		$(function(){
			$('body').on('change', 'input[name^="ignoreSalePromotions"]', function() {
				var wrapper = $(this).parent().parent().parent().parent();
				if ($(this).is(':checked')) {
					wrapper.find('input[name^="discountedPrice"]').each(function() {
						$(this).prop('disabled', false);
						$(this).removeClass('x-item-disabled');
						$(this).width(525);
						$(this).siblings().show();
						$(this).siblings().css('display', 'inline');
					});
				} else {
					wrapper.find('input[name^="discountedPrice"]').each(function() {
						$(this).prop('disabled', true);
						$(this).addClass('x-item-disabled');
						$(this).width(543);
						$(this).siblings().hide();
					});
				}
			});
			$('body').on('click', 'div.objectlayout_element_price_tabs ul.x-tab-strip li a', function() {
				$('input[name^="ignoreSalePromotions"]').change();
			});
		});
    },

	postOpenObject: function(object) {
		//download invoice button
		if (object.data.general.o_classId == 3) {
			if (!object.data.data.fromStore) {
				//download invoice button
				if (object.data.data.invoiceId) {
					backendPlugin.insertDownloadInvoiceButton(object);
				}
				//credit note button
				if (object.data.data.invoiceId && object.data.data.creditNoteId) {
					backendPlugin.insertDownloadCreditNoteButton(object);
				}
				//activate/deactivate Issue invoice buttton
				if (object.data.data.invoiceId) {
					backendPlugin.toggleIssueInvoiceButton(object, false);
				} else {
					backendPlugin.toggleIssueInvoiceButton(object, true);
				}
				//activate/deactivate Issue credit note buttton
				if (object.data.data.creditNoteId) {
					backendPlugin.toggleIssueCreditNoteButton(object, false);
				} else {
					backendPlugin.toggleIssueCreditNoteButton(object, true);
				}
			} else {
				//hide unused inputs
				$('#object_'+object.id+' div.objectlayout_element_addresses').hide();
				$('#object_'+object.id+' div.objectlayout_element_invoice-info').hide();
			}
			//activate recalculate button
			$('#object_'+object.id+' table.objectlayout_element_order-recalculate').click(function() {
				backendPlugin.recalculateOrder(object);
			});
			//activate recalculate help button
			$('#object_'+object.id+' table.objectlayout_element_order-recalculate-help').click(function() {
				backendPlugin.recalculateOrderHelp(object);
			});
		}

		//close Localized data and Product data accordeon panels on product variants
		//hide additional categories and brand on variants
		if (object.data.general.o_classId == 1 && object.data.general.o_type == 'variant') {
			$('#object_'+object.id+' .objectlayout_element_additional_categories_selector').next().hide();
			$('#object_'+object.id+' .objectlayout_element_additional_categories_selector').next().next().hide();
		}

		// discounted price enabling/disabling init
		$('#object_'+object.id+' input[name^="ignoreSalePromotions"]').change();

		//hide viriants panel on non-variant
		if (object.data.general.o_type == 'object') {
			$('#object_'+object.id+' div.objectlayout_element_variant_data').hide();
		}

		if (pimcore.settings.disabledCurrencies && pimcore.settings.disabledCurrencies.length) {
			for (var i in pimcore.settings.disabledCurrencies) {
				if (pimcore.settings.disabledCurrencies.hasOwnProperty(i)) {
					$("#object_"+object.id+" div.objectlayout_element_price_tabs ul li a em span span:contains('"+pimcore.settings.disabledCurrencies[i]+"')").hide();
				}
			}
		}

	},

	toggleIssueInvoiceButton: function (object, active) {
		var button = $('#object_'+object.id+' table.objectlayout_element_issue-invoice');
		var showInvoiceCheckbox = $('#object_'+object.id+' input[name="showInvoice"]');
		if (!active) {
			button.hide();
			showInvoiceCheckbox.prop('disabled', false);
			showInvoiceCheckbox.removeClass('x-item-disabled');
		} else {
			showInvoiceCheckbox.prop('disabled', true);
			showInvoiceCheckbox.addClass('x-item-disabled');
			button.click(function() {
				backendPlugin.issueInvoice(object);
			});
		}
	},

	issueInvoice: function (object) {
		pimcore.globalmanager.get("loadingmask").show();
		Ext.Ajax.request({
			url: '/plugin/Backend/index/issue-invoice?id='+object.id,
			success: function (response) {
				var res = Ext.decode(response.responseText);
				if (res.status) {
					$('#object_'+object.id+' input[name="invoiceId"]').val(res.invoiceId);
					$('#object_'+object.id+' input[name="issuedOn"]').val(res.issuedOn);
					$('#object_'+object.id+' input[name="issuedOn"]').change();
					$('#object_'+object.id+' input[name="dueTo"]').val(res.dueTo);
					$('#object_'+object.id+' input[name="dueTo"]').change();
					backendPlugin.toggleIssueInvoiceButton(object, false);
					backendPlugin.insertDownloadInvoiceButton(object);
				} else {
					Ext.MessageBox.alert(t("error"), t(res.errorCode));
				}
				pimcore.globalmanager.get("loadingmask").hide();
			},
			failure: function () {
				pimcore.globalmanager.get("loadingmask").hide();
				Ext.MessageBox.alert(t("error"), t("plugin_backend_error_issuing_invoice"));
			}
		});
	},

	toggleIssueCreditNoteButton: function (object, active) {
		var button = $('#object_'+object.id+' table.objectlayout_element_issue-credit-note');
		if (!active) {
			button.hide();
		} else {
			button.click(function() {
				backendPlugin.issueCreditNote(object);
			});
		}
	},

	issueCreditNote: function (object) {
		pimcore.globalmanager.get("loadingmask").show();
		Ext.Ajax.request({
			url: '/plugin/Backend/index/issue-invoice?id='+object.id+'&credit-note=1',
			success: function (response) {
				var res = Ext.decode(response.responseText);
				if (res.status) {
					$('#object_'+object.id+' input[name="creditNoteId"]').val(res.creditNoteId);
					$('#object_'+object.id+' input[name="cnIssuedOn"]').val(res.issuedOn);
					$('#object_'+object.id+' input[name="cnIssuedOn"]').change();
					$('#object_'+object.id+' input[name="cnDueTo"]').val(res.dueTo);
					$('#object_'+object.id+' input[name="cnDueTo"]').change();
					backendPlugin.toggleIssueCreditNoteButton(object, false);
					backendPlugin.insertDownloadCreditNoteButton(object);
				} else {
					Ext.MessageBox.alert(t("error"), t(res.errorCode));
				}
				pimcore.globalmanager.get("loadingmask").hide();
			},
			failure: function () {
				pimcore.globalmanager.get("loadingmask").hide();
				Ext.MessageBox.alert(t("error"), t("plugin_backend_error_issuing_credit_note"));
			}
		});
	},

	insertDownloadInvoiceButton: function(object) {
		object.toolbar.insert(2, {
			text: t('plugin_backend_invoice'),
			itemId: 'downloadInvoice',
			scale: 'medium',
			iconCls: 'pimcore_icon_download_medium',
			handler: function() {
				pimcore.globalmanager.get("loadingmask").show();
				Ext.Ajax.request({
					url: '/plugin/Backend/index/prepare-invoice?id='+object.id,
					success: function (response) {
						var res = Ext.decode(response.responseText);
						if (res.status) {
							pimcore.helpers.download("/plugin/Backend/index/download-invoice?name="+res.name);
						} else {
							Ext.MessageBox.alert(t("error"), t("plugin_backend_error_generating_invoice"));
						}
						pimcore.globalmanager.get("loadingmask").hide();
					},
					failure: function () {
						pimcore.globalmanager.get("loadingmask").hide();
						Ext.MessageBox.alert(t("error"), t("plugin_backend_error_generating_invoice"));
					}
				});
			}
		});
		pimcore.layout.refresh();
	},

	insertDownloadCreditNoteButton: function(object) {
		object.toolbar.insert(3, {
			text: t('plugin_backend_credit_note'),
			itemId: 'downloadCreditNote',
			scale: 'medium',
			iconCls: 'pimcore_icon_download_medium',
			handler: function() {
				pimcore.globalmanager.get("loadingmask").show();
				Ext.Ajax.request({
					url: '/plugin/Backend/index/prepare-invoice?credit-note=1&id='+object.id,
					success: function (response) {
						var res = Ext.decode(response.responseText);
						if (res.status) {
							pimcore.helpers.download("/plugin/Backend/index/download-invoice?name="+res.name);
						} else {
							Ext.MessageBox.alert(t("error"), t("plugin_backend_error_generating_credit_note"));
						}
						pimcore.globalmanager.get("loadingmask").hide();
					},
					failure: function () {
						pimcore.globalmanager.get("loadingmask").hide();
						Ext.MessageBox.alert(t("error"), t("plugin_backend_error_generating_credit_note"));
					}
				});
			}
		});
		pimcore.layout.refresh();
	},

	/**
	 * The prefered flow is to request a change via AJAX, make the change on the PHP side (because of uneditable elements changes)
	 * and then return the changes to the JS handler, which will reflect them on the ExtJS GUI
	 * (you might want to save the Pimcore JS object after that to get rid of the "unsaved changes star")
	 */
	recalculateOrder: function(order) {
		pimcore.globalmanager.get("loadingmask").show();

		var params = {};
		params.orderId = order.id;
		var liveData = order.edit.getValues();
		//compose the request 'products' param
		var products = [];
		if (liveData.products !== undefined) {
			for (var key in liveData.products) if(liveData.products.hasOwnProperty(key)) {
				var productId = liveData.products[key].data.product.id;
				var count = liveData.products[key].data.count;
				if (!count) count = 1;
				products.push(key+':'+productId+':'+count);
			}
			params.products = products.join('|');
		}
		//get other simple params
		if (liveData.shippingType !== undefined) {
			params.shippingType = liveData.shippingType;
		}
		if (liveData.paymentType !== undefined) {
			params.paymentType = liveData.paymentType;
		}
		if (liveData.currency !== undefined) {
			params.currency = liveData.currency;
		}
		if (liveData.discountCode !== undefined) {
			params.discountCode = (liveData.discountCode.id !== undefined) ? liveData.discountCode.id : 'deleted';
		}

		Ext.Ajax.request({
			url: '/plugin/Backend/index/recalculate-order?'+$.param(params),
			success: function (response) {
				var res = Ext.decode(response.responseText);
				if (res.status) {
					//products
					for (var fieldCollectionKey in res.products) if(res.products.hasOwnProperty(fieldCollectionKey)) { 
						var fieldCollectionBlock = order.edit.dataFields.products.currentElements[fieldCollectionKey];
						fieldCollectionBlock.fields[1].component.setValue(res.products[fieldCollectionKey].name);
						fieldCollectionBlock.fields[2].component.setValue(res.products[fieldCollectionKey].count);
						fieldCollectionBlock.fields[3].component.setValue(res.products[fieldCollectionKey].price);
						fieldCollectionBlock.fields[4].component.setValue(res.products[fieldCollectionKey].cost);
						fieldCollectionBlock.fields[5].component.setValue(res.products[fieldCollectionKey].vat);
						fieldCollectionBlock.fields[7].component.setValue(res.products[fieldCollectionKey].isLowVat);
					}
					//shipping
					order.edit.dataFields.shippingPrice.component.setValue(res.shippingPrice)
					order.edit.dataFields.baseShippingPrice.component.setValue(res.baseShippingPrice)
					order.edit.dataFields.shippingDiscount.component.setValue(res.shippingDiscount)
					order.edit.dataFields.shippingCost.component.setValue(res.shippingCost)
					//payment
					order.edit.dataFields.paymentPrice.component.setValue(res.paymentPrice)
					order.edit.dataFields.basePaymentPrice.component.setValue(res.basePaymentPrice)
					order.edit.dataFields.paymentDiscount.component.setValue(res.paymentDiscount)
					order.edit.dataFields.paymentCost.component.setValue(res.paymentCost)
					//summary
					order.edit.dataFields.productsPrice.component.setValue(res.productsPrice)
					order.edit.dataFields.productsDiscount.component.setValue(res.productsDiscount)
					order.edit.dataFields.finalPrice.component.setValue(res.finalPrice)
				} else {
					Ext.MessageBox.alert(t("error"), t("plugin_backend_error_recalculating_order_prices"));
				}
				pimcore.globalmanager.get("loadingmask").hide();
			},
			failure: function () {
				pimcore.globalmanager.get("loadingmask").hide();
				Ext.MessageBox.alert(t("error"), t("plugin_backend_error_recalculating_order_prices"));
			}
		});


	},

	recalculateOrderHelp: function(object)
	{
		var inputElementQuery = "input[name='product'], input[name='count'], input[name='paymentType'], input[name='shippingType'], input[name='discountCode'],";
		inputElementQuery += "input[name='currency']";
		var outputElementQuery = "input[name='name'], input[name='price'], input[name='cost'], input[name='vat'], input[name='isLowVat'],";
		outputElementQuery += "input[name='shippingPrice'], input[name='baseShippingPrice'], input[name='shippingDiscount'], input[name='shippingCost'],";
		outputElementQuery += "input[name='paymentPrice'], input[name='basePaymentPrice'], input[name='paymentDiscount'], input[name='paymentCost'],";
		outputElementQuery += "input[name='productsDiscount'], input[name='productsPrice'], input[name='finalPrice']";

		var inputElements = Ext.fly('object_'+object.id).query(inputElementQuery);
		var outputElements = Ext.fly('object_'+object.id).query(outputElementQuery);

		var element;
		for(var i = 0; i < inputElements.length; i++) {
			element = Ext.get(inputElements[i]).up("div[id^='ext-gen']");
			if(object.recalculateHelpHighlighted) {
				element.unmask();
			} else {
				var maskInput = element.mask();
				maskInput.setStyle("background-color","#2EB847");
			}
		}

		for(var j = 0; j < outputElements.length; j++) {
			element = Ext.get(outputElements[j]).up("div[id^='ext-gen']");
			if(object.recalculateHelpHighlighted) {
				element.unmask();
			} else {
				var maskOutput = element.mask();
				maskOutput.setStyle("background-color","#FF5050");
			}
		}
		object.recalculateHelpHighlighted = (object.recalculateHelpHighlighted) ? false : true;
	}
});

var backendPlugin = new pimcore.plugin.backend();

