<?php

namespace Website\Model;

class Category extends \Pimcore\Model\Object\Category implements IElasticObjectFulltext
{
	use ElasticTrait;

	public $forceChain = false;

	/*								Helpers										*/

	/*								Mapped										*/

	public function save()
	{
		$systemLanguages = \Pimcore\Tool::getValidLanguages();
		$updatePath = false;
		if (parent::getId()) {
			foreach ($systemLanguages as $lang) {
				//translated path
				$translatedPath = parent::getTranslatedPath($lang);
				$newTranslatedPath = \Website\Tool\Utils::webalize(parent::getName($lang));
				//check if translated path is unique
				$list = $this->getList();
				$list->setCondition('o_id <> '.(int)parent::getId().' AND translatedPath = '.$list->quote($newTranslatedPath));
				if ($list->count()) {
					$msg = \Pimcore\Model\Translation\Admin::getByKeyLocalized(
						'error_category_name_not_unique', false, true
					);
					throw new \Pimcore\Model\Element\ValidationException($msg);
					return;
				}
				//translatedPath is going to change => add old path to redirects
				if (($translatedPath != $newTranslatedPath) && !empty($translatedPath)) {
					\Website\Tool\Utils::addToOldEshopUrls(parent::getId(), parent::getClassId(), $translatedPath, $lang);
				}
				//update childs when translatedPath was changed
				$updatePath = ($updatePath || ($newTranslatedPath != $translatedPath));
				parent::setTranslatedPath($newTranslatedPath, $lang);
			}
		}
		//save object
		parent::save();

		$this->elasticSearchUpdateFulltext();

		//update all childs
		if ($this->forceChain ||$updatePath || \Website\Tool\ElasticSearch::isUpdateRequest()) {
			foreach (parent::getChilds() as $child) {
				try {
					$child->setOmitMandatoryCheck(true);
					$child->save();
				} catch(\Exception $e) {
					\Pimcore\Log\Simple::log('exceptions', 'CHAIN SAVING: could not save child with ID: '.$child->getId().' - '.$e->getMessage());
				}
			}
		}

		//update products with this category in additionalCategories field
		if (parent::getId() && $updatePath) {
			$db = \Pimcore\Db::get();
			foreach($db->select()->from('object_1', ['oo_id as id'])->where('additionalCategories LIKE ?', '%'.parent::getId().'%')->query()->fetchAll() as $rawDbRow) {
				$product = Product::getById($rawDbRow['id']);
				if ($product) {
					try {
						$product->setOmitMandatoryCheck(true);
						$product->save();
					} catch (\Exception $e) {
						\Pimcore\Log\Simple::log('exceptions', 'CHAIN SAVING: could not save product with ID: '.$child->getId());
					}
				}
			}
		}
	}

	public function delete()
	{
		$this->elasticSearchDeleteFulltext();

		parent::delete();
	}

	/* 								For elastic search							 */

	/**
	 * returns elastic search document data structure 
	 * @param string $lang
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang)
	{
		$data = array_merge($this->getElasticBaseData(), [
			'path' => $this->getUrl($lang),
			'title' => $this->getName($lang),
			'keywords' => $this->getSeoKeywords($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => ''//is paginated so the content is irelevant
		]);

		return $data;
	}

}
