<?php

namespace Website\Model;

class EshopSettings extends \Pimcore\Model\Object\EshopSettings
{

	public function save()
	{
		if (!parent::getId()) {
			$msg = \Pimcore\Model\Translation\Admin::getByKeyLocalized(
				'error_only_one_instance_of_eshop_settings_allowed', false, true
			);
			throw new \Pimcore\Model\Element\ValidationException($msg);
			return;
		}

		$exchangeRateShadow = parent::getExchangeRateShadow();
		$exchangeRate = md5(serialize(parent::getExchangeRate()->data));

		parent::setExchangeRateShadow($exchangeRate);

		$result = parent::save();

		//recalculate product prices, discount values and sale promotion values
		if ($exchangeRate != $exchangeRateShadow) {
			//discount code values
			$dcQueue = \Pimcore\Model\Object\Folder::getById(\Website\Tool\Utils::FOLDER_DISCOUNT_CODES)->getChilds([
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
			]);
			while ($discountCode = array_shift($dcQueue)) {
				if ($discountCode instanceof DiscountCode) {
					$discountCode->save();
				} else {
					foreach ($discountCode->getChilds([
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
					]) as $tmp) {
						array_push($dcQueue, $tmp);
					}
				}
			}
			//sale promotion values
			$spQueue = \Pimcore\Model\Object\Folder::getById(\Website\Tool\Utils::FOLDER_SALE_PROMOTIONS)->getChilds([
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
			]);
			while ($salePromotion = array_shift($spQueue)) {
				if ($salePromotion instanceof SalePromotion) {
					$salePromotion->setRecalculate(false); //do not recalculate, it will be done when saving products...
					$salePromotion->save();
				} else {
					foreach ($salePromotion->getChilds([
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
					]) as $tmp) {
						array_push($spQueue, $tmp);
					}
				}
			}
			//product prices
			foreach (\Pimcore\Model\Object\Folder::getById(\Website\Tool\Utils::FOLDER_CATALOG)->getChilds([
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT
			]) as $productOrCategory) {
				if ($productOrCategory instanceof Category) $productOrCategory->forceChain = true;
				if ($productOrCategory instanceof Product || $productOrCategory instanceof Category) {
					$productOrCategory->save();
				}
			}
		}

		return $result;
	}

	public function delete()
	{
		$msg = \Pimcore\Model\Translation\Admin::getByKeyLocalized(
			'error_eshop_settings_cannot_be_deleted', false, true
		);
		throw new \Pimcore\Model\Element\ValidationException($msg);
	}

}
