<?php

/**
 * simple exchange service for zend currency
 * 
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Model;

class ExchangeService implements \Zend_Currency_CurrencyInterface
{

	protected $defaultCurrency;
	protected $exchangeRate;
	protected $frozen = false;

	/**
	 * @param \Website\Model\Currency $currency
	 */
	public function __construct($defaultCurrencyShortName, $systemCurrencies, $frozen = false)
	{
		if ($frozen) {
			$this->frozen = true;
			return;
		}

		$this->defaultCurrency = $defaultCurrencyShortName;

		foreach ($systemCurrencies as $locale => $settings) {
			if (!$settings['rate']) {//just because we allow rate 0 to be set in backend which means currency should be input directly in products etc and not exchanged automatically
				$settings['rate'] = 1;
			}
			$tmp = new \Zend_Currency($settings, $locale);
			$this->exchangeRate[$tmp->getShortName()] = $settings['rate'];
		}
	}

	public function getRate($from, $to)
	{
		if ($this->frozen)
			return 1;

		if ($from !== $this->defaultCurrency || !isset($this->exchangeRate[$to])) {
			throw new \Exception('Currency exchange error.');
			return;
		}

		return 1 / $this->exchangeRate[$to];
	}

}
