<?php

class FeedController extends \Website\Controller\BaseController
{
	private $cacheKey = null;
	private $feed = null;
	private $saveToCache = true;
	private $format = 'xml';

	public function init()
	{
		parent::init();

		$this->disableLayout();
		$this->disableViewAutoRender();
	}

	public function preDispatch()
	{
		parent::preDispatch();

		$this->cacheKey = \Website\Tool\Utils::toCacheKey(
			'website_feed_'.$this->getRequest()->getActionName().'_'.$this->language
		);

		$clearCache = $this->getRequest()->getParam('clearcache');
		if ($clearCache) {
			\Pimcore\Cache::remove($this->cacheKey);
		}

		$this->feed = \Pimcore\Cache::load($this->cacheKey);
		if ($this->feed) {
			$this->saveToCache = false;
		}
	}

	public function postDispatch()
	{
		parent::postDispatch();

		if ($this->saveToCache) {
			\Pimcore\Cache::save($this->feed, $this->cacheKey, ['website_feeds'], 60 * 60 * 23);
		}

		switch ($this->format) {
			case 'json': {
				$this->_helper->json($this->feed);
			} break;
			case 'xml': {
				$filename = $this->getRequest()->getActionName().'.xml';
				header('Content-Description: File Transfer');
				header('Content-Type: text/xml');
				header('Content-Disposition: attachment; filename='.$filename);
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
				echo $this->feed;
			} break;
		}
		exit;
	}

	public function heurekaAction()
	{
		if (!$this->feed) {
			$feedManager = new \Website\Model\FeedManager($this->language);
			$this->feed = $feedManager->getHeurekaXml($this->currencyModel);
		}
	}

	public function zboziAction()
	{
		if (!$this->feed) {
			$feedManager = new \Website\Model\FeedManager($this->language);
			$this->feed = $feedManager->getZboziXml($this->currencyModel);
		}
	}
}
