<?php

namespace Website\Form;

class CartForm extends Base
{
	protected $cart = null;

	public function __construct($cart)
	{
		$this->cart = $cart;

		parent::__construct(null);
	}

	public function init()
	{
		parent::init();
		$this->setName('cartform');

		//add count inputs
		foreach ($this->cart->getOrder()->products as $key => $product) {
			$element = new \Zend_Form_Element_Text('count_'.$key);
			$element->setRequired(true)
				->setLabel('label_product_count')
				->setValue($product->count)
				->addFilter('StripTags')
				->addFilter('StringTrim')
				->addValidator($this->notEmptyValidator)
				->addvalidator($this->numberValidator);
			$this->addElement($element);
		}

		$csrf = new \Zend_Form_Element_Hash('csrf');
		$csrf->setDisableTranslator(true);

		$submit = new \Zend_Form_Element_Submit('send');
		$submit->setLabel('label_continue_with_order');

		$this->addElements([
			$csrf,
			$submit,
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);
	}
}
