<?php

namespace Website\Model;

class News extends \Pimcore\Model\Object\News implements IElasticObjectFulltext
{
	use ElasticTrait;

	/*								Helpers										*/

	/*								Mapped										*/

	public function save()
	{
		parent::save();

		$this->elasticSearchUpdateFulltext();
	}

	public function delete()
	{
		$this->elasticSearchDeleteFulltext();

		parent::delete();
	}

	/* 								For elastic search							 */

	/**
	 * returns elastic search document data structure.
	 *
	 * @param string $lang
	 *
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang)
	{
		\Website\Tool\Utils::forceInheritanceAndFallbackValues();

		$data = array_merge($this->getElasticBaseData(), [
			'path' => $this->getUrl($lang),
			'title' => $this->getName($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => $this->renderView('cms/news-detail.php', $lang, [
				'news' => $this,
			]),
		]);

		\Website\Tool\Utils::restorInheritanceAndFallbackValues();

		return $data;
	}
}
