<?php

namespace Website\Model;

class Order extends \Pimcore\Model\Object\Order
{
	public function save()
	{
		$status = parent::getStatus();
		$statusShadow = parent::getStatusShadow();

		if ($status == \Website\Model\OrderManager::STATUS_COMPLETE && $status != $statusShadow) {
			//check tracking number
			if ((parent::getShippingType() == \Website\Model\OrderManager::SHIPPING_CZECH_POST || parent::getShippingType() == \Website\Model\OrderManager::SHIPPING_CZECH_PPL) &&  !parent::getTrackingNumber()) {
				$msg = \Pimcore\Model\Translation\Admin::getByKeyLocalized(
					'error_enter_order_tracking_number', false, true
				);
				throw new \Pimcore\Model\Element\ValidationException($msg);
				exit;
			}
			$locale = parent::getCurrency();
			$translator = new \Pimcore\Translate\Website(substr($locale, 0, 2));
			$shop = new OrderManager($translator, new \Website\Model\Currency($locale));
			$shop->sendCompletionEmail($this);
		}

		parent::setStatusShadow(parent::getStatus());

		parent::save();
	}

	public function delete()
	{
		if (parent::getInvoiceId()) {
			$msg = \Pimcore\Model\Translation\Admin::getByKeyLocalized(
				'error_order_connected_to_invoice', false, true
			);
			throw new \Pimcore\Model\Element\ValidationException($msg);

			return false;
		} else {
			parent::delete();
		}
	}
}
