<?php

class Backend_IndexController extends \Pimcore\Controller\Action\Admin
{

	public function disabledCurrenciesAction()
	{
		$exchangeRate = \Website\Tool\Utils::getEshopSettings()->getExchangeRate()->data;
		$map = ['cz' => 'Kč', 'sk' => '€ (SR)'];
		$currencies = [];
		foreach ($exchangeRate as $locale => $options) {
			if (!$options['isactive'] || (!$options['isdefault'] && $options['rate'] != 0 && $options['rate'] != 1)) {
				$currencies[] = substr($locale, 3);
			}
		}
		foreach ($currencies as $key => $value) {
			$currencies[$key] = $map[$value];
		}

		$this->_helper->json($currencies);
	}

	public function issueInvoiceAction()
	{
		$orderId = $this->getRequest()->getParam('id');
		$creditNote = $this->getRequest()->getParam('credit-note');

		$order = \Website\Model\Order::getById($orderId);

		if (!$order) {
			$response = ($creditNote)
				? ['status' => false, 'errorCode' => 'plugin_backend_error_issuing_credit_note']
				: ['status' => false, 'errorCode' => 'plugin_backend_error_issuing_invoice'];
			$this->_helper->json($response);
		}

		$translator = new \Pimcore\Translate\Website(substr($order->getCurrency(), 0, 2));
		$shop = new \Website\Model\OrderManager($translator, new \Website\Model\Currency($order->getCurrency()));

		if ($creditNote) {
			$order = $shop->genCreditNote($orderId);
		} else {
			$order = $shop->genInvoice($orderId);
		}


		if ($order instanceof \Website\Model\Order) {
			if ($creditNote) {
				$response = [
					'status' => true,
					'creditNoteId' => $order->getCreditNoteId(),
					'issuedOn' => date('d.m.Y', $order->getCnIssuedOn()->getTimestamp()),
					'dueTo' => date('d.m.Y', $order->getCnDueTo()->getTimestamp())
				];
			} else {
				$response = [
					'status' => true,
					'invoiceId' => $order->getInvoiceId(),
					'issuedOn' => date('d.m.Y', $order->getIssuedOn()->getTimestamp()),
					'dueTo' => date('d.m.Y', $order->getDueTo()->getTimestamp())
				];
			}
		} elseif ($order == -1) {
			$response = ($creditNote)
				? ['status' => false, 'errorCode' => 'plugin_backend_error_issuing_credit_note_no_invoice']
				: ['status' => false, 'errorCode' => 'plugin_backend_error_issuing_invoice_bad_status'];
		} else {
			$response = ($creditNote)
				? ['status' => false, 'errorCode' => 'plugin_backend_error_issuing_credit_note']
				: ['status' => false, 'errorCode' => 'plugin_backend_error_issuing_invoice'];
		}
		$this->_helper->json($response);
		exit;
	}

	public function prepareInvoiceAction()
	{
		$this->view->addBasePath(PIMCORE_WEBSITE_PATH . '/views/');

		$response = [];
		$this->disableLayout();
		$this->disableViewAutoRender();

		$id = $this->getRequest()->getParam('id');
		$isCreditNote = (bool)$this->getRequest()->getParam('credit-note');
		$order = \Website\Model\Order::getById($id);
		if (!$order instanceof \Website\Model\Order) {
			$response['status'] = false;
		} else {
			$settings = \Website\Tool\Utils::getEshopSettings();
			$path = str_replace('\\', '/', PIMCORE_TEMPORARY_DIRECTORY);
			$name = $order->getInvoiceId();
			if ($isCreditNote) {
				$name .= '-dobropis';
			}

			$this->view->currencyModel = new \Website\Model\Currency();
			$translate = new \Pimcore\Translate\Website(substr($order->getCurrency(), 0, 2));
			$this->view->translate()->setTranslator($translate);
			$this->view->order = $order;
			$this->view->settings = $settings;
			$this->view->isCreditNote = $isCreditNote;
			$this->view->doNotCacheLayout = true;
			$template = $this->view->render('shop/invoice-pdf.php');

			require_once PIMCORE_WEBSITE_PATH . '/lib/MPDF57/mpdf.php';
			$mpdf = new mPDF();
			$mpdf->WriteHTML($template);
			$mpdf->Output($path . '/' . $name . '.pdf');

			if ($name) {
				$response['status'] = true;
				$response['name'] = $name;
			} else {
				@unlink($path . '/' . $order->getOrderId());
				$response['status'] = false;
			}
		}

		$this->_helper->json($response);
		exit;
	}

	public function downloadInvoiceAction()
	{
		$this->removeViewRenderer();

		$name = $this->getRequest()->getParam('name');
		$path = str_replace('\\', '/', PIMCORE_TEMPORARY_DIRECTORY);

		header("Content-Type: application/pdf", true);
		header(sprintf('Content-Disposition: attachment; filename="%s"', $name . '.pdf'));
		header("Content-Length: " . filesize($path . '/' . $name . '.pdf'), true);

		while (@ob_end_flush());
		flush();

		readfile($path . '/' . $name . '.pdf');
		@unlink($path . '/' . $name);
		exit;
	}

	public function prepareVarioExportAction()
	{
		$exportCreditNotes = $this->getRequest()->getParam('credit-notes');

		$translator = new \Pimcore\Translate\Website('cs');
		$shop = new \Website\Model\OrderManager($translator, new \Website\Model\Currency('cs_CZ'));

		$this->_helper->json($shop->varioExport(
			strtotime($this->getRequest()->getParam('since')),
			strtotime($this->getRequest()->getParam('until')) + 60 * 60 * 24 - 1,
			$exportCreditNotes
		));
		exit;
	}

	public function downloadVarioExportAction()
	{
		$this->removeViewRenderer();

		$exportCreditNotes = $this->getRequest()->getParam('credit-notes');

		$name = ($exportCreditNotes) ? 'vario-export-credit-notes.zip' : 'vario-export-invoices.zip';
		$path = str_replace('\\', '/', PIMCORE_TEMPORARY_DIRECTORY);
		$file = $path . '/' . $name;

		header("Content-Type: application/zip", true);
		header(sprintf('Content-Disposition: attachment; filename="%s"', $name));
		header("Content-Length: " . filesize($file), true);

		while (@ob_end_flush());
		flush();

		readfile($file);
		@unlink($file);
		exit;
	}

	public function createNewOrderAction()
	{
		$response = [];
		$this->disableLayout();
		$this->disableViewAutoRender();

		$translator = new \Pimcore\Translate\Website('cs');
		$shop = new \Website\Model\OrderManager($translator, new \Website\Model\Currency('cs_CZ'));

		$newOrder = $shop->createOrderByHand();

		if (!$newOrder) {
			$response['status'] = false;
		} else {
			$response['status'] = true;
			$response['id'] = $newOrder->getId();
		}

		$this->_helper->json($response);
		exit;
	}

	public function recalculateOrderAction()
	{
		$this->disableLayout();
		$this->disableViewAutoRender();

		$order = \Website\Model\Order::getById($this->getRequest()->getParam('orderId'));

		if (!$order) {
			return $this->_helper->json(['status' => false]);
		}

		$locale = ($this->getRequest()->getParam('currency')) ? $this->getRequest()->getParam('currency') : $order->getCurrency();

		$translator = new \Pimcore\Translate\Website(substr($locale, 0, 2));
		$shop = new \Website\Model\OrderManager($translator, new \Website\Model\Currency($locale));

		$response = $shop->recalculateOrder(
			$this->getRequest()->getParam('orderId'),
			$this->getRequest()->getParam('products'),
			$this->getRequest()->getParam('shippingType'),
			$this->getRequest()->getParam('paymentType'),
			$this->getRequest()->getParam('discountCode'),
			false	
		);

		$this->_helper->json($response);
		exit;
	}

	public function reindexElasticAction()
	{
		$response = ['status' => true];
		$this->disableLayout();
		$this->disableViewAutoRender();

		\Website\Tool\ElasticSearch::updateMappingsAndReindex(true, true);

		$this->_helper->json($response);
		exit;
	}

}
