<?php

namespace Website\Form;

class FilterForm extends Base
{
	protected $currencyModel = null;

	public function __construct($options = null, \Website\Model\Currency $currencyModel = null)
	{
		$this->currencyModel = $currencyModel;

		parent::__construct($options);
	}

	public function init()
	{
		parent::init();
		$this->setMethod(self::METHOD_GET);
		$this->setName('filter');
		$this->setAttrib('persist-to-hash', true);

		$locale = \Zend_Registry::get('Zend_Locale');

		//elements
		$query = new \Zend_Form_Element_Text('query');
		$query->setRequired(false)
				->setLabel('label_query')
				->addFilter('StripTags')
				->addFilter('StringTrim');

		$brands = new \Zend_Form_Element_MultiCheckbox('brand');
		$brands->setLabel('label_brand');
		$brands->setRequired(false)->setDisableTranslator(true)
			->setMultiOptions(\Website\Tool\Utils::getFilterBrands($locale->getLanguage()));

		$colors = new \Zend_Form_Element_MultiCheckbox('color');
		$colors->setLabel('label_color');
		$colors->setRequired(false)->setDisableTranslator(true)
			->setMultiOptions(\Website\Tool\Utils::getFilterColors($locale->getLanguage()));

		$sizes = new \Zend_Form_Element_MultiCheckbox('size');
		$sizes->setLabel('label_size');
		$sizes->setRequired(false)->setDisableTranslator(true)
			->setMultiOptions(\Website\Tool\Utils::getFilterSizes($locale->getLanguage()));

		$priceMultiOptions = [];
		foreach(\Website\Tool\Utils::getFilterPriceBuckets($this->currencyModel->getCountry()) as $id => $bucket) {
			$priceMultiOptions[$id] = $this->composePriceBucketLabel($bucket);
		}
		$prices = new \Zend_Form_Element_MultiCheckbox('price');
		$prices->setLabel('label_price');
		$prices->setRequired(false)->setDisableTranslator(true)->setMultiOptions($priceMultiOptions);

		$new = new \Zend_Form_Element_Checkbox('new');
		$new->setRequired(false)->setLabel('label_filter_is_new');

		$sale = new \Zend_Form_Element_Checkbox('sale');
		$sale->setRequired(false)->setLabel('label_filter_is_on_sale');

		$page = new \Zend_Form_Element_Hidden('page');

		$sort = new \Zend_Form_Element_Hidden('sort');

		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_filter')
				->setAttrib('type', 'submit');

		$this->addElements([
			$query,
			$brands,
			$colors,
			$sizes,
			$prices,
			$new,
			$sale,
			$page,
			$sort,
			$submit
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}

	private function composePriceBucketLabel($bucket)
	{
		$symbol = $this->currencyModel->getCurrency()->getSymbol();
		$label = '';
		if(!isset($bucket['from'])) $label .= 'Méně než ';
		else $label .= $bucket['from'].' '.$symbol;
				
		if(count($bucket) > 1) $label .= ' - ';

		if(!isset($bucket['to'])) $label .= ' a více';
		else $label .= $bucket['to'].' '.$symbol;

		return $label;
	}

}
