<?php

namespace Website\Form;

class GpeWebPayRequestForm extends Base
{

	public function init()
	{
		parent::init();
		$this->setName('webpay');

		//elements
		$merchantNumber = new \Zend_Form_Element_Hidden('MERCHANTNUMBER');
		$merchantNumber->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$operation = new \Zend_Form_Element_Hidden('OPERATION');
		$operation->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$orderNumber = new \Zend_Form_Element_Hidden('ORDERNUMBER');
		$orderNumber->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$amount = new \Zend_Form_Element_Hidden('AMOUNT');
		$amount->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$currency = new \Zend_Form_Element_Hidden('CURRENCY');
		$currency->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$depositFlag = new \Zend_Form_Element_Hidden('DEPOSITFLAG');
		$depositFlag->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$merOrderNum = new \Zend_Form_Element_Hidden('MERORDERNUM');
		$merOrderNum->setRequired(false)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$url = new \Zend_Form_Element_Hidden('URL');
		$url->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$description = new \Zend_Form_Element_Hidden('DESCRIPTION');
		$description->setRequired(false)
				->addValidator($this->notEmptyValidator);

		$md = new \Zend_Form_Element_Hidden('MD');
		$md->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$digest = new \Zend_Form_Element_Hidden('DIGEST');
		$digest->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$submit = new \Zend_Form_Element_Submit('send');
		$submit->setLabel('label_pay');

		$this->addElements([
			$merchantNumber,
			$operation,
			$orderNumber,
			$amount,
			$currency,
			$depositFlag,
			$merOrderNum,
			$url,
			$description,
			$md,
			$digest,
			$submit
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);
	}

}
