<?php

namespace Website\Form;

class PasswordChangeForm extends Base
{

	public function init()
	{
		parent::init();
		$this->setName('change-password');

		$password_old = new \Zend_Form_Element_Password('password_old');
		$password_old->setRequired(true)
				->setLabel('label_password_old')
				->addFilter('StripTags')
				->addFilter('StripTags')
				->addValidator($this->notEmptyValidator)
				->addValidator($this->passwordLengthValidator);

		$password = new \Zend_Form_Element_Password('password');
		$password->setRequired(true)
				->setLabel('label_password_new')
				->addFilter('StripTags')
				->addFilter('StripTags')
				->addValidator($this->notEmptyValidator)
				->addValidator($this->passwordLengthValidator);

		$password_again = new \Zend_Form_Element_Password('password_again');
		$password_again->setRequired(true)
				->setLabel('label_password_new_again')
				->addFilter('StripTags')
				->addFilter('StripTags')
				->addValidator($this->notEmptyValidator)
				->addValidator($this->passwordLengthValidator)
				->addValidator($this->passwordIdenticalValidator);

		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_change')
				->setAttrib('type', 'submit');

		$this->addElements([
			$password_old,
			$password,
			$password_again,
			$submit
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}

}
