<?php

namespace Website\Model;

class News extends \Pimcore\Model\Object\News implements IElasticObjectFulltext 
{
	use ElasticTrait;

	/*								Helpers										*/

	/*								Mapped										*/

	public function save()
	{
		parent::save();

		$this->elasticSearchUpdateFulltext();
	}

	public function delete()
	{
		$this->elasticSearchDeleteFulltext();

		parent::delete();
	}

	/* 								For elastic search							 */

	/**
	 * returns elastic search document data structure 
	 * @param string $lang
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang)
	{
		$view = new \Pimcore\View();
		$view->setScriptPath([
			PIMCORE_WEBSITE_PATH . '/views/scripts',
			PIMCORE_WEBSITE_PATH . '/views/layouts'
		]);
		$view->addHelperPath(PIMCORE_WEBSITE_PATH . '/views/helpers', '\\Website\\View\\Helper');
		$view->news = $this;

		\Website\Tool\Utils::forceInheritanceAndFallbackValues();

		$data = array_merge($this->getElasticBaseData(), [
			'path' => $this->getUrl($lang),
			'title' => $this->getName($lang),
			'keywords' => $this->getSeoKeywords($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => $this->normalizeElasticText($view->render('cms/news-detail.php'))
		]);

		\Website\Tool\Utils::restorInheritanceAndFallbackValues();

		return $data;
	}

}
