<?php

namespace Website\Model;

class UserManager
{

	const ROOT_FOLDER_ID = 13;

	protected $translator;

	public function __construct($translator)
	{
		$this->translator = $translator;
	}

	public function createUser($data)
	{
		try {
			$user = \Pimcore\Model\Object\User::create($data);
			$user->setKey(\Pimcore\File::getValidFilename($data['email']));
			$user->setParentId(self::ROOT_FOLDER_ID);
			$user->setPublished(false);
			$user->save();
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'REGISTRATION - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
			$this->addErrorMsg($this->translate('msg_unknown_error'));

			return false;
		}
		//send email
		$helper = new \Zend_View_Helper_ServerUrl();
		$mailManager = new \Website\Model\MailManager();
		$mailManager->sendMail(\Pimcore\Model\Document\Email::getByPath('/' . $data['lang'] . '/notifikace/registrace'), $data['email'], null, [
			'siteUrl' => $helper->serverUrl() . '/' . $data['lang'],
			'activationUrl' => $helper->serverUrl().\Website\Tool\Utils::url('activate-account', [
				'language' => $data['lang'],
				'code' => $data['activationCode']
			]),
			'user' => $user
		]);

		return true;
	}

	public function quickRegistration($data, $lang, $password = null)
	{
		$onlyPreRegister = (!$password);

		//try to load existing acc (when not logged)
		$list = new \Pimcore\Model\Object\User\Listing();
		$list->setUnpublished(true);
		$list->setCondition(\Pimcore\Db::get()->quoteInto('email = ?', $data['fEmail']));
		$list->setLimit(1);
		$user = $list->current();

		//already pre-registered or registered (difference doesn't matter)
		if ($onlyPreRegister && $user instanceof \Pimcore\Model\Object\User) {
			return $user;
		}

		$activationCode = uniqid();
		$pass = ($password) ? $password : substr(uniqid(), 0, 8);
		$hashedPass = \Website\Model\Auth::calculateHash($pass);

		$regData = [];
		$regData['activationCode'] = $activationCode;
		$regData['password'] = $hashedPass;
		$regData['firstName'] = $data['fFirstName'];
		$regData['lastName'] = $data['fLastName'];
		$regData['email'] = $data['fEmail'];
		$regData['phone'] = $data['fPhone'];
		$regData['street'] = $data['fStreet'];
		$regData['city'] = $data['fCity'];
		$regData['zipCode'] = $data['fZipCode'];
		$regData['company'] = $data['fCompany'];
		$regData['ico'] = $data['fIco'];
		$regData['dic'] = $data['fDic'];
		$regData['lang'] = $lang;

		try {
			//user
			if (!$user instanceof \Pimcore\Model\Object\User) {
				$user = \Pimcore\Model\Object\User::create($regData);
				$user->setKey(\Pimcore\File::getValidFilename($regData['email']));
				$user->setParentId(self::ROOT_FOLDER_ID);
			} else {
				$user->setValues($regData);
			}
			$user->setPublished(!$onlyPreRegister);

			$user->save();
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'QUICK REGISTRATION - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
			return false;
		}

		//inform user about quick registration
		if (!$onlyPreRegister) {
			$helper = new \Zend_View_Helper_ServerUrl();
			$mailer = new \Website\Model\MailManager();
			$mailer->sendMail(\Pimcore\Model\Document\Email::getByPath('/' . $lang . '/notifikace/automaticka-registrace'), $regData['email'], null, [
				'user' => $user,
				'password' => $pass,
				'siteUrl' => $helper->serverUrl()
			]);
		}

		return $user;
	}

}