<?php

/**
 * Helper for printing price
 * 
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\View\Helper;

class PrintPrice extends \Zend_View_Helper_Abstract
{

	public $view;

	protected function _run()
	{
		
	}

	/**
	 * @param \Website\Model\Product|array $product the product object
	 * 
	 * @return string localized currency value
	 */
	public function printPrice($product = null)
	{
		list($price, $discountedPrice) = $this->view->currencyModel->getProductPrices($product);

		if ($price <= $discountedPrice) {
			return $this->view->localizeCurrency($discountedPrice, true);
		} else {
			return $this->view->localizeCurrency($discountedPrice, true) . ' <strike>' . $this->view->localizeCurrency($price, true) . '</strike>';
		}
	}

	public function setView(\Zend_View_Interface $view)
	{
		parent::setView($view);

		$this->view = $view;
	}

}
