<div class="col-md-12">
	<div class="page-header">
		<h1>Objednávka</h1>
	</div>
	<?if($this->order->getShowInvoice()):?>
		<h4>
			<a class="btn btn-default" href="<?=\Website\Tool\Utils::url('invoice-'.$this->language, ['id' => $this->order->getId()]);?>">
				<span class="glyphicon glyphicon-file"></span>&nbsp;Faktura
			</a>
		</h4>
	<?endif;?>

	<table class="table table-striped">
		<thead>
			<tr>
				<th>Název</th>
				<th>Cena s DPH</th>
				<th>Počet ks</th>
				<th>Celkem</th>
			</tr>
		</thead>
		<tbody>
			<?
				$locale = $this->order->getCurrency();
				$currency = $this->currencyModel->createFrozenCurrency($locale);
				$discount = min([$this->order->getProductsPrice(), $this->order->getProductsDiscount()]) + $this->order->getShippingDiscount() + $this->order->getPaymentDiscount();
			?>
			<?foreach($this->order->getProducts() as $id => $product):?>
				<?
					$productObject = $product->getProduct();
				?>
				<tr>
					<?if($productObject instanceof \Website\Model\Product):?>
						<td><?=$productObject->getVariantName($this->language);?></td>
					<?else:?>
						<td><?=$product->getName();?></td>
					<?endif;?>
					<td><?=$this->currencyModel->localizeCurrency($product->getPrice(), $currency);?></td>
					<td><?=$product->getCount();?></td>
					<td><?=$this->currencyModel->localizeCurrency($this->order->getProductsPrice(), $currency);?></td>
				</tr>	
			<?endforeach;?>
			<?if($this->order->getBaseShippingPrice()):?>
				<tr>
					<td><strong><?=$this->translate('label_shipping');?></strong><br><?=$this->translate('label_'.$this->order->shippingType);?></td>
					<td></td>
					<td></td>
					<td><?=$this->currencyModel->localizeCurrency($this->order->getBaseShippingPrice(), $currency);?></td>
				</tr>
			<?endif;?>
			<?if($this->order->getBasePaymentPrice()):?>
				<tr>
					<td><strong><?=$this->translate('label_payment');?></strong><br><?=$this->translate('label_'.$this->order->paymentType);?></td>
					<td></td>
					<td></td>
					<td><?=$this->currencyModel->localizeCurrency($this->order->getBasePaymentPrice(), $currency);?></td>
				</tr>
			<?endif;?>
			<?if($discount):?>
				<tr>
					<td><strong><?=$this->translate('label_discount');?></strong></td>
					<td></td>
					<td></td>
					<td><?='-'.$this->currencyModel->localizeCurrency($discount, $currency);?></td>
				</tr>
			<?endif;?>
		</tbody>
		<tfoot>
			<tr>
				<th>Celkem</th>
				<th></th>
				<th></th>
				<th><?=$this->currencyModel->localizeCurrency($this->order->getFinalPrice(), $currency);?></th>
			</tr>
		</tfoot>
	</table>
</div>

<?$this->layout()->setLayout('standard');?>
