<?php

/**
 * Simple contact form, without decorators.
 */
namespace Website\Form;

class ContactForm extends Base
{
	public function init()
	{
		parent::init();
		$this->setName('contact-form');

		//elements
		$fullName = new \Zend_Form_Element_Text('fullName');
		$fullName->setRequired(true)
			->setLabel('label_full_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$email = new \Zend_Form_Element_Text('email');
		$email->setRequired(true)
			->setLabel('label_email')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->emailValidator);

		$phone = new \Zend_Form_Element_Text('phone');
		$phone->setRequired(true)
			->setLabel('label_phone')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addFilter('PregReplace', ['match' => '/ /', 'replace' => ''])
			->addValidator($this->notEmptyValidator)
			->addValidator($this->phoneValidator);

		$message = new \Zend_Form_Element_Textarea('message');
		$message->setRequired(true)
			->setLabel('label_message_text')
			->setAttrib('rows', 6)
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$submit = new \Zend_Form_Element_Submit('send');
		$submit->setLabel('label_submit_question');

		$this->addElements([
			$fullName,
			$email,
			$phone,
			$message,
			$submit,
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}
}
