<?php

namespace Website\Model;

class DiscountCode extends \Pimcore\Model\Object\DiscountCode
{
	public function save()
	{
		$currencyModel = \Website\Tool\Utils::getCurrencyModel();
		$systemCurrencies = $currencyModel->getSystemCurrencies();
		$baseLocale = $currencyModel->getBaseLocale();
		$baseDiscountGetter = 'getDiscount'.substr($baseLocale, 3);
		foreach ($currencyModel->getSystemCurrenciesOptions(true) as $locale => $currencyOptions) {
			$country = substr($locale, 3);
			$discountSetter = 'setDiscount'.$country;

			//calculate exchange rate based discount prices
			if ($locale != $baseLocale && $currencyOptions['rate'] && $currencyOptions['rate'] != 1) {
				if (parent::getIsPercentual()) {
					parent::$discountSetter(parent::$baseDiscountGetter());
				} else {
					parent::$discountSetter($currencyModel->localizeCurrency(parent::$baseDiscountGetter(), $systemCurrencies[$locale], true));
				}
			}
		}

		parent::save();
	}
}
