<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorControllerFormHandlerCreateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:controller-form-handler-create')
			->setDescription('Create a form handler inside a controller')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Form handler name in CamelCase'
			)
			->addArgument(
				'controller',
				InputArgument::OPTIONAL,
				'Controller name in CamelCase without the Controller suffix',
				'Cms'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new \Website\Tool\Generator();

		$name = ucfirst($input->getArgument('name'));
		$controller = ucfirst($input->getArgument('controller'));

		if ($generator->createFormHandler($name, $controller)) {
			$output->writeln(sprintf(
				'Form handler [handle%sForm] created in [%sController]',
				$name,
				$controller
			));
		} else {
			$output->writeln(sprintf(
				'<error>Form handler [handle%sForm] could not be created in [%sController]. See /website/var/log/generator.log for details.</error>',
				$name,
				$controller
			));
		}
	}
}
