<?php


$baseMapping = [
	'id' => ['type' => 'integer', 'include_in_all' => false],
	'parentId' => ['type' => 'integer', 'include_in_all' => false],
	'key' => ['type' => 'string', 'include_in_all' => false, 'index' => 'not_analyzed'],
	'type' => ['type' => 'string', 'include_in_all' => false, 'index' => 'not_analyzed'],
	'published' => ['type' => 'boolean', 'include_in_all' => false],
];

return [
	'product' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
			'fulltextFields' => ['name', 'description'],
		],
		'properties' => array_merge($baseMapping, [
			'name_suggest' => [
				'type' => 'completion', 'index_analyzer' => 'simple',
				'search_analyzer' => 'simple', 'payloads' => true,
			],
			'translatedPath' => [
				'type' => 'string', 'index_analyzer' => 'pathIndexAnalyzer',
				'search_analyzer' => 'keyword', 'include_in_all' => false,
			],
			'searchPaths' => [
				'type' => 'string', 'index_analyzer' => 'pathIndexAnalyzer',
				'search_analyzer' => 'keyword', 'include_in_all' => false,
			],
			'previewImage' => ['type' => 'string', 'include_in_all' => false],
			'priceCZ' => ['type' => 'float', 'include_in_all' => false],
			'priceSK' => ['type' => 'float', 'include_in_all' => false],
			'discountedPriceCZ' => ['type' => 'float', 'include_in_all' => false],
			'discountedPriceSK' => ['type' => 'float', 'include_in_all' => false],
			'inStock' => ['type' => 'integer', 'include_in_all' => false],
			'isNew' => ['type' => 'boolean', 'include_in_all' => false],
			'isOnSale' => ['type' => 'boolean', 'include_in_all' => false],
			'soldCount' => ['type' => 'integer', 'include_in_all' => false],
			'isVariant' => ['type' => 'boolean', 'include_in_all' => false],
			'isMasterProduct' => ['type' => 'boolean', 'include_in_all' => false],
			'brand' => ['type' => 'integer', 'include_in_all' => false],
			'color' => ['type' => 'integer', 'include_in_all' => false],
			'size' => ['type' => 'integer', 'include_in_all' => false],
			'colors' => ['type' => 'integer', 'include_in_all' => false],
			'sizes' => ['type' => 'integer', 'include_in_all' => false],
			'ordering' => ['type' => 'integer', 'include_in_all' => false],
		]),
	],
	'default_mapping' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
		],
		'properties' => array_merge($baseMapping, [
			'path' => ['type' => 'string', 'include_in_all' => false],
		]),
	],
	'fulltext_mapping' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
			'fulltextFields' => ['title', 'description', 'content'],
		],
		'properties' => array_merge($baseMapping, [
			'path' => ['type' => 'string', 'include_in_all' => false],
		]),
	],
];
