<div class="col-md-12">
	<div class="page-header">
		<h1>Košík - Kontaktní a platební údaje</h1>
	</div>


	<?
		/* @var $formBuilder \Website\View\Helper\FormBuilder */
		$formBuilder = $this->formBuilder($this->cartInfoForm, 'bootstrap');
		$formBuilder->setAutoPopulateData($this->userAddress)->setAutoPopulateDataPrefix('f');
	?>
	<?=$formBuilder->start();?>	
	<div class="well">
		<fieldset>
			<legend>Doprava a platba</legend>
		</fieldset>
		<?=$formBuilder->element('country');?>
		<div class="row">
			<?foreach($this->shopModel->getShippingAndPaymentTypePrices(
				$this->cart->getOrder()->productsPrice,
				$this->cart->getProductsDiscount()->discountValue,
				($this->cart->getOrder()->discountCode && $this->cart->getProductsDiscount()->code->getApplyOnShipping()) ? true : false
			) as $country => $shippingAndPaymentSettings):?>
				<div class="country-shipping" data-country="<?=$country;?>">
					<div class="col-md-6">
						<div class="well">
							<h3>Způsob dopravy</h3>
							<?
								$ext = [];
								foreach ($shippingAndPaymentSettings as $shippingCode => $shippingSettings) {
									if (!$shippingSettings['price']) {
										$ext[$shippingCode] = '<span class="price free r"> (Zdarma)</span>';
									} else {
										$ext[$shippingCode] = sprintf('<span class="price r"> (%s)</span>', $this->localizeCurrency($shippingSettings['price'], true));
									}
								}
								$formBuilder->setRadioLabelHint($ext);
							?>
							<?=$formBuilder->setEncode(false)->element('shippingType'.$country);?>
						</div>
					</div>
					<div class="col-md-6">
						<div class="well">
							<h3>Způsob platby</h3>
							<?foreach($shippingAndPaymentSettings as $shippingCode => $shippingSettings):?>
								<div class="payment-switcher" data-type="<?=$country.$shippingCode?>">
									<?
										$tmpOrderPrice = $shippingSettings['price'];
										$tmpOrderPrice += ($this->cart->getProductsDiscount()->discountValue) ? $this->cart->getProductsDiscount()->discountedPrice : $this->cart->getOrder()->productsPrice;
										$ext = [];
										foreach ($shippingSettings['paymentPrices'] as $paymentCode => $paymentPrices) {
											$paymentPrice = $paymentPrices['price'];
											$paymentSpanId = 'paymentType'.$country.$shippingCode.$paymentCode;
											$orderPrice = $this->localizeCurrency($tmpOrderPrice + $paymentPrice, true);
											if (!$paymentPrice) {
												$ext[$paymentCode] = sprintf('<span id="price_%s" data-price="%s" class="price free r"> (Zdarma)</span>', $paymentSpanId, $orderPrice);
											} else {
												$ext[$paymentCode] = sprintf('<span id="price_%s" data-price="%s" class="price r"> (%s)</span>', $paymentSpanId, $orderPrice, $this->localizeCurrency($paymentPrice, true));
											}
										}
										$formBuilder->setRadioLabelHint($ext);
									?>
									<?=$formBuilder->element('paymentType'.$country.$shippingCode);?>
								</div>
							<?endforeach;?>
						</div>
					</div>
				</div>
			<?endforeach;?>
		</div>
		<?=$this->shippingDiscountInfo(
			$this->shopModel->getShippingDiscountSteps($this->cart->getOrder()->productsPrice),
			($this->cart->getProductsDiscount()->discountValue) ? $this->cart->getProductsDiscount()->discountedPrice : $this->cart->getOrder()->productsPrice
		);?>
	</div>

	<div class="well">
		<fieldset>
			<legend>Fakturační údaje</legend>
		</fieldset>
		<?=$formBuilder->setEncode(true)->element('fFirstName')->element('fLastName')->element('fEmail')->element('fPhone')
			->element('fStreet')->element('fCity')->element('fZipCode')->element('fCompany')->element('fIco')->element('fDic');?>
	</div>
			
	<div class="well">
		<fieldset>
			<legend>Dodací adresa</legend>
		</fieldset>
		<?=$formBuilder->element('deliveryAddress');?>
		<div id="delivery-address">
			<?=$formBuilder->setExplicitRequired(true)->element('dCompany')->element('dFirstName')->element('dLastName')
				->element('dStreet')->element('dCity')->element('dZipCode')->setExplicitRequired(false);?>
		</div>
	</div>

	<div class="well">
		<div class="input-group form-group<?if($this->cartInfoForm->discountCode->hasErrors()):?> error<?elseif($this->cart->getProductsDiscount()->discountValue):?> success<?endif;?>">
			<?=$formBuilder->setInputElementWrapperClass(null)->setInputWrapperClass(null)->setPlaceholder(true)->element('discountCode');?>
			<span class="input-group-btn">
				<a href="javascript:$('#cartinfoform').submitForm({'act':'discount'});" class="btn btn-default">Aktivovat</a>
			</span>
			<?if(!$this->cartInfoForm->discountCode->hasErrors() && $this->cart->getProductsDiscount()->discountValue):?>
				<p class="help-block">&nbsp;<?=sprintf($this->translate('msg_active_discount'), $this->localizeCurrency($this->cart->getProductsDiscount()->discountValue, true));?></p>
			<?endif;?>
		</div>
	</div>
			
	<div class="well">
		<fieldset>
			<legend>Poznámka</legend>
		</fieldset>
		<?=$formBuilder->setForm($this->cartInfoForm, 'bootstrap')->element('message');?>
	</div>

	<h3 class="price">Objednávka celkem: <b><span id="dynamic-price"></span></b></h3>
	<p>Kliknutím na "Objednat" souhlasíte s <a href="<?=$this->docUrl('/obchodni-podminky');?>" target="_blank">Obchodními podmínkami</a>.</p>
	<?=$formBuilder->setButtonClass('btn btn-primary')->element('send');?>
	<?=$formBuilder->element('csrf');?>
	<?=$formBuilder->end();?>
</div>

<?$this->layout()->setLayout('standard');?>
