<?php

namespace Website\Form;

class QuickRegistrationForm extends Base
{

	public function init()
	{
		parent::init();
		$this->setName('auto-registration');

		//elements
		$email = new \Zend_Form_Element_Text('email');
		$email->setRequired(false)
				->setLabel('label_email')
				->setAttrib('disabled', 'disabled')
				->addFilter('StripTags')
				->addFilter('StringTrim')
				->addValidator($this->notEmptyValidator)
				->addValidator($this->emailValidator);

		$password = new \Zend_Form_Element_Password('password');
		$password->setRequired(true)
				->setLabel('label_password')
				->addFilter('StripTags')
				->addFilter('StripTags')
				->addValidator($this->notEmptyValidator)
				->addValidator($this->passwordLengthValidator);

		$password_again = new \Zend_Form_Element_Password('password_again');
		$password_again->setRequired(true)
				->setLabel('label_password_again')
				->addFilter('StripTags')
				->addFilter('StripTags')
				->addValidator($this->notEmptyValidator)
				->addValidator($this->passwordLengthValidator)
				->addValidator($this->passwordIdenticalValidator);

		$agreed = new \Zend_Form_Element_Checkbox('agreed');
		$agreed->setRequired(true)
				->setLabel('label_agree_with_terms')
				->addFilter('StripTags')
				->addFilter('StringTrim')
				->addValidator($this->notEmptyValidator);

		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_register')
				->setAttrib('type', 'submit');

		$this->addElements(array(
			$email,
			$password,
			$password_again,
			$agreed,
			$submit
		));

		//remove decorators
		$this->setElementDecorators(array('ViewHelper'));

		$this->setUpJsValidation();
	}

}
