<?php

namespace Website\Model;

class EshopSettings extends \Pimcore\Model\Object\EshopSettings
{

	public function save()
	{
		$exchangeRateShadow = parent::getExchangeRateShadow();
		$exchangeRate = md5(serialize(parent::getExchangeRate()->data));

		parent::setExchangeRateShadow($exchangeRate);

		$result = parent::save();

		//recalculate product prices, discount values and sale promotion values
		if ($exchangeRate != $exchangeRateShadow) {
			//discount code values
			$dcQueue = \Pimcore\Model\Object\Folder::getById(\Website\Tool\Utils::FOLDER_DISCOUNT_CODES)->getChilds(array(
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
			));
			while ($discountCode = array_shift($dcQueue)) {
				if ($discountCode instanceof DiscountCode) {
					$discountCode->save();
				} else {
					foreach ($discountCode->getChilds(array(
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
					)) as $tmp) {
						array_push($dcQueue, $tmp);
					}
				}
			}
			//sale promotion values
			$spQueue = \Pimcore\Model\Object\Folder::getById(\Website\Tool\Utils::FOLDER_SALE_PROMOTIONS)->getChilds(array(
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
			));
			while ($salePromotion = array_shift($spQueue)) {
				if ($salePromotion instanceof SalePromotion) {
					$salePromotion->setRecalculate(false); //do not recalculate, it will be done when saving products...
					$salePromotion->save();
				} else {
					foreach ($salePromotion->getChilds(array(
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT,
						\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_FOLDER
					)) as $tmp) {
						array_push($spQueue, $tmp);
					}
				}
			}
			//product prices
			foreach (\Pimcore\Model\Object\Folder::getById(\Website\Tool\Utils::FOLDER_CATALOG)->getChilds(array(
				\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT
			)) as $productOrCategory) {
				if ($productOrCategory instanceof Category) $productOrCategory->forceChain = true;
				if ($productOrCategory instanceof Product || $productOrCategory instanceof Category) {
					$productOrCategory->save();
				}
			}
		}

		return $result;
	}

}
