<?php

/**
 * pimcore installator extension
 * 
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Tool;

class Setup extends \Pimcore\Model\Tool\Setup 
{
	private $db;

	public function __construct() {
		$this->db = \Pimcore\Db::getConnection();
	}

    public function config($config = array()) {
        // write configuration file
        $settings = array(
            "general" => array(
                "timezone" => "Europe/Prague",
                "php_cli" => "",
                "domain" => "",
                "redirect_to_maindomain" => "",
                "language" => "en",
                "validLanguages" => "cs",
                "fallbackLanguages" => array(
                    "cs" => ""
                ),
                "defaultLanguage" => "",
                "theme" => "",
                "contactemail" => "",
                "extjs6" => "1",
                "loginscreencustomimage" => "",
                "disableusagestatistics" => "",
                "debug" => "1",
                "debug_ip" => "127.0.0.1,90.180.56.75,90.179.155.74",
                "http_auth" => array(
                    "username" => "",
                    "password" => ""
                ),
                "custom_php_logfile" => "1",
                "environment" => "",
                "debugloglevel" => "error",
                "disable_whoops" => "1",
                "debug_admin_translations" => "",
                "devmode" => "",
                "logrecipient" => "",
                "viewSuffix" => "",
                "instanceIdentifier" => "",
                "show_cookie_notice" => ""
            ),
            "database" => array(
                "adapter" => "Mysqli",
                "params" => array(
                    "host" => "localhost",
                    "username" => "root",
                    "password" => "",
                    "dbname" => "",
                    "port" => "3306",
                )
            ),
            "documents" => array(
                "versions" => array(
                    "days" => "",
                    "steps" => "5"
                ),
                "default_controller" => "default",
                "default_action" => "default",
                "error_pages" => array(
                    "default" => "/system/chybova-stranka"
                ),
                "createredirectwhenmoved" => "",
                "allowtrailingslash" => "no",
                "allowcapitals" => "no",
                "generatepreview" => "",
                "wkhtmltoimage" => "",
                "wkhtmltopdf" => ""
            ),
            "objects" => array(
                "versions" => array(
                    "days" => "",
                    "steps" => "5"
                )
            ),
            "assets" => array(
                "webdav" => array(
                      "hostname" => ""
                ),
                "versions" => array(
                    "days" => "",
                    "steps" => "0"
                ),
                "ffmpeg" => "",
                "ghostscript" => "",
                "libreoffice" => "",
                "pngcrush" => "",
                "imgmin" => "",
                "jpegoptim" => "",
                "pdftotext" => "",
                "icc_rgb_profile" => "",
                "icc_cmyk_profile" => "",
                "hide_edit_image" => ""
            ),
            "services" => array(
                "translate" => array(
                    "apikey" => ""
                ),
                "google" => array(
                    "client_id" => "",
                    "email" => "",
                    "simpleapikey" => "",
                    "browserapikey" => ""
                )
            ),
            "cache" => array(
                "enabled" => "",
                "lifetime" => "",
                "excludePatterns" => "",
                "excludeCookie" => ""
            ),
            "outputfilters" => array(
                "less" => "",
                "lesscpath" => ""
            ),
            "webservice" => array(
                "enabled" => ""
            ),
            "httpclient" => array(
                "adapter" => "Zend_Http_Client_Adapter_Socket",
                "proxy_host" => "",
                "proxy_port" => "",
                "proxy_user" => "",
                "proxy_pass" => ""
            ),
            "applicationlog" => array(
                "mail_notification" => array(
                    "send_log_summary" => "",
                    "filter_priority" => "",
                    "mail_receiver" => ""
                ),
                "archive_treshold" => "30",
                "archive_alternative_database" => ""
            ),
            "email" => array(
                "sender" => array(
                    "name" => "",
                    "email" => "noreply@vm3.portadesign.cz"
                ),
                "return" => array(
                    "name" => "",
                    "email" => ""
                ),
                "method" => "sendmail",
                "smtp" => array(
                    "host" => "",
                    "port" => "",
                    "ssl" => "",
                    "name" => "",
                    "auth" => array(
                        "method" => "",
                        "username" => "",
                        "password" => ""
                    )
                ),
                "debug" => array(
                    "emailaddresses" => "noreply@portadesign.cz"
                ),
                "bounce" => array(
                    "type" => "",
                    "maildir" => "",
                    "mbox" => "",
                    "imap" => array(
                        "host" => "",
                        "port" => "",
                        "username" => "",
                        "password" => "",
                        "ssl" => ""
                    )
                )
            ),
            "newsletter" => array(
                "sender" => array(
                    "name" => "",
                    "email" => ""
                ),
                "return" => array(
                    "name" => "",
                    "email" => ""
                ),
                "method" => "",
                "smtp" => array(
                    "host" => "",
                    "port" => "",
                    "ssl" => "",
                    "name" => "",
                    "auth" => array(
                        "method" => "",
                        "username" => "",
                        "password" => ""
                    )
                ),
                "usespecific" => ""
            )
        );

        $settings = array_replace_recursive($settings, $config);

        // create initial /website/var folder structure
        // @TODO: should use values out of startup.php (Constants)
        $varFolders = array("areas","assets","backup","cache","classes","config","email","log","plugins","recyclebin","search","system","tmp","versions","webdav");
        foreach($varFolders as $folder) {
            \Pimcore\File::mkdir(PIMCORE_WEBSITE_VAR . "/" . $folder);
        }

        $config = new \Zend_Config($settings, true);
        $writer = new \Zend_Config_Writer_Xml(array(
            "config" => $config,
            "filename" => PIMCORE_CONFIGURATION_SYSTEM
        ));
        $writer->write();
    }

    public function cacheConfig($config = array())
    {
        $settings = array(
            "frontend" => array(
                "type" => "Core",
                "options" => array(
                    "cache_id_prefix" => "websitename_",
                    "lifetime" => "99999",
                    "automatic_serialization" => "true"
                )
            ),
            "backend" => array(
                "type" => "\Pimcore\Cache\Backend\Redis2",
                "custom" => "true",
                "options" => array(
                    "server" => "127.0.0.1",
                    "port" => "6379",
                    "persistent" => "1",
                    "database" => "1",
                    "use_lua" => "1"
                )
            )
        );

        $settings = array_replace_recursive($settings, $config);

        $config = new \Zend_Config($settings, true);
        $writer = new \Zend_Config_Writer_Xml(array(
            "config" => $config,
            "filename" => PIMCORE_CONFIGURATION_DIRECTORY.'/cache.xml'
        ));
        $writer->write();
    }

    public function elasticSearch()
    {
        \Website\Tool\ElasticSearch::updateElasticSearchIndexesAndMappings(false, false);
    }

	public function databaseExtension()
	{

		$mysqlInstallScript = file_get_contents(PIMCORE_WEBSITE_PATH . "/tools/Setup/install_extension.sql");

		// get every command as single part
		$mysqlInstallScripts = explode(";", $mysqlInstallScript);

		// execute every script with a separate call, otherwise this will end in a PDO_Exception "unbufferd queries, ..." seems to be a PDO bug after some googling
		foreach ($mysqlInstallScripts as $m) {
			$sql = trim($m);
			if (strlen($sql) > 0) {
				$sql .= ";";
				$this->db->query($m);
			}
		}

		// reset the database connection
		\Pimcore\Db::reset();
	}

	public function databaseExtensionContents()
	{
		$time = time();

		$dbExtension = array(
			'assets' => array(
				'schema' => array('id', 'parentId', 'type', 'filename', 'path', 'mimetype', 'creationDate', 'modificationDate', 'userOwner', 'userModification', 'customSettings', 'hasMetaData'),
				'data' => array(
					2, 1, 'folder', 'produkty', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					3, 1, 'folder', 'kategorie', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					4, 1, 'folder', 'novinky', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					5, 4, 'folder', 'galerie', '/novinky/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					6, 1, 'folder', 'dokumenty', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					9, 2, 'folder', 'obrazky', '/produkty/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					10, 2, 'folder', 'nahladove-obrazky', '/produkty/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					13, 1, 'folder', 'system', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					14, 1, 'folder', 'znacky', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0
				)
			),
			'classes' => array(
				'schema' => array('id', 'name', 'description', 'creationDate', 'modificationDate', 'userOwner', 'userModification', 'allowInherit', 'allowVariants', 'parentClass', 'useTraits', 'icon', 'previewUrl', 'propertyVisibility', 'showVariants'),
				'data' => array(
					1, 'Product', '', $time, $time, 2, 2, 1, 1, '', NULL, '/pimcore/static/img/icon/box.png', '/cs/%translatedPath', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 1,
					2, 'Category', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/folder.png', '/cs/%translatedPath', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					3, 'Order', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/package.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					4, 'News', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/newspaper.png', '/cs/aktuality/%o_id-%slug', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					5, 'ContactForm', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/email.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:0;s:4:"path";b:1;s:9:"published";b:0;s:16:"modificationDate";b:0;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:0;s:4:"path";b:1;s:9:"published";b:0;s:16:"modificationDate";b:0;s:12:"creationDate";b:1;}}', 0,
					6, 'NewsletterForm', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/email.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					7, 'DiscountCode', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/money_add.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					8, 'SalePromotion', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/basket_put.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					9, 'EshopSettings', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/cog.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					10, 'User', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/user.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					11, 'ProductColor', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/color_wheel.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					12, 'ProductSize', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/shapes_many.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					14, 'Brand', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/text_inverse.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0
				)
			),
			'documents' => array(
				'schema' => array('id', 'parentId', 'type', 'key', 'path', 'index', 'published', 'creationDate', 'modificationDate', 'userOwner', 'userModification'),
				'data' => array(
					2, 1, 'page', 'cs', '/', 0, 1, $time, $time, 2, 2,
					3, 1, 'folder', 'system', '/', 2, 1, $time, $time, 2, 2,
					5, 2, 'folder', 'notifikace', '/cs/', 12, 1, $time, $time, 2, 2,
					6, 5, 'email', 'newsletter', '/cs/notifikace/', 2, 1, $time, $time, 2, 2,
					7, 3, 'page', 'chybova-stranka', '/system/', 0, 1, $time, $time, 2, 2,
					8, 2, 'page', 'o-nas', '/cs/', 2, 1, $time, $time, 2, 2,
					9, 2, 'page', 'kontakt', '/cs/', 5, 1, $time, $time, 2, 2,
					10, 2, 'page', 'doprava-a-platba', '/cs/', 3, 1, $time, $time, 2, 2,
					11, 2, 'page', 'obchodni-podminky', '/cs/', 4, 1, $time, $time, 2, 2,
					12, 2, 'page', 'ucet', '/cs/', 7, 1, $time, $time, 2, 2,
					14, 5, 'email', 'registrace', '/cs/notifickace/', 0, 1, $time, $time, 2, 2,
					15, 5, 'email', 'automaticka-registrace', '/cs/notifikace/', 3, 1, $time, $time, 2, 2,
					16, 5, 'email', 'reset-hesla', '/cs/notifikace/', 1, 1, $time, $time, 2, 2,
					17, 2, 'page', 'kosik', '/cs/', 6, 1, $time, $time, 2, 2,
					18, 5, 'email', 'pro-administratora-nova-objednavka', '/cs/notifikace/', 13, 1, $time, $time, 2, 2,
					19, 5, 'email', 'potvrzeni-objednavky-platba-hotove', '/cs/notifikace/', 5, 1, $time, $time, 2, 2,
					20, 2, 'page', 'porovnani-produktu', '/cs/', 9, 1, $time, $time, 2, 2,
					21, 2, 'page', 'mapa-stranek', '/cs/', 10, 1, $time, $time, 2, 2,
					22, 2, 'page', 'aktuality', '/cs/', 1, 1, $time, $time, 2, 2,
					24, 5, 'email', 'pro-administratora-novy-kontaktni-formular', '/cs/notifikace/', 14, 1, $time, $time, 2, 2,
					25, 2, 'page', 'produkty', '/cs/', 0, 1, $time, $time, 2, 2,
					26, 2, 'page', 'prihlaseni', '/cs/', 8, 1, $time, $time, 2, 2,
					27, 2, 'page', 'vysledky-vyhledavani', '/cs/', 11, 1, $time, $time, 2, 2,
					28, 12, 'page', 'zmena-hesla', '/cs/ucet/', 1, 1, $time, $time, 2, 2,
					29, 12, 'page', 'objednavky', '/cs/ucet/', 2, 1, $time, $time, 2, 2,
					30, 12, 'page', 'profil', '/cs/ucet/', 3, 1, $time, $time, 2, 2,
					31, 17, 'page', 'kontaktni-a-platebni-udaje', '/cs/kosik/', 1, 1, $time, $time, 2, 2,
					32, 31, 'page', 'rekapitulace', '/cs/kosik/kontaktni-a-platebni-udaje/', 1, 1, $time, $time, 2, 2,
					33, 5, 'email', 'potvrzeni-objednavky-zdarma', '/cs/notifikace/', 4, 1, $time, $time, 2, 2,
					34, 5, 'email', 'potvrzeni-objednavky-platba-na-dobirku', '/cs/notifikace/', 6, 1, $time, $time, 2, 2,
					35, 5, 'email', 'potvrzeni-objednavky-platba-prevodem', '/cs/notifikace/', 7, 1, $time, $time, 2, 2,
					36, 5, 'email', 'potvrzeni-objednavky-platba-kartou', '/cs/notifikace/', 8, 1, $time, $time, 2, 2,
					37, 5, 'email', 'vyrizeni-objednavky-osobni-odber', '/cs/notifikace/', 9, 1, $time, $time, 2, 2,
					38, 5, 'email', 'vyrizeni-objednavky-ceska-posta', '/cs/notifikace/', 10, 1, $time, $time, 2, 2,
					39, 5, 'email', 'vyrizeni-objednavky-ppl', '/cs/notifikace/', 11, 1, $time, $time, 2, 2,
					40, 5, 'email', 'vyrizeni-objednavky-ulozenka', '/cs/notifikace/', 12, 1, $time, $time, 2, 2
				)
			),
			'documents_doctypes' => array(
				'schema' => array('id', 'name', 'module', 'controller', 'action', 'template', 'type', 'priority', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'Simple page', '', 'cms', 'template-simple', '', 'page', 0, $time, $time
				)
			),
			'documents_elements' => array(
				'schema' => array('documentId', 'name', 'type', 'data'),
				'data' => array(
					6, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme, že jste se přihlásili k odběru našeho newletteru.</p><p>Jestliže jste se do newsletteru nepřihlásili dobrovolně nebo se v budoucnu budete chtít odhlásit, můžete použít nasledující odkaz k odhlášení:</p><p><a href="%Text(unsubscribeUrl);">%Text(unsubscribeUrl);</a></p><p>Pimshop</p>',
					14, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za registraci na našich stránkách <a href="%Text(siteUrl);">%Text(siteUrl);</a>. Pro dokončení registrace použijte následující odkaz:</p><p><a href="%Text(activationUrl);">%Text(activationUrl);</a></p><p>Pimshop</p>',
					15, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Na stránkách <a href="%Text(siteUrl);">%Text(siteUrl);</a> byl na Váš e-mail automaticky vytvořen účet.</p><p>Pimshop</p>',
					16, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Na Vašem účtu bylo požádáno o resetování hesla. Heslo si můžete změnit přes nasledujúcí odkaz:</p><p><strong>%Text(link);</strong></p><p>Pimshop</p>',
					18, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>V systému byla založena nová objednávka s číslem <strong><a href="%Text(deeplink);">%Object(order, {"method":"getOrderId"});</a></strong>.</p><p>číslo objednávky: <strong>%Object(order, {"method":"getOrderId"});</strong><p/><p>Objednávka:</p><p>%Text(products);</p><p>%Text(orderInfo);</p><p>Fakturační adresa:</p><p>%Text(invoiceAddress);</p><p>Dodací adresa:</p><p>%Text(deliveryAddress);</p><p>Pimshop</p>',
					19, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za nákup v našem e-shopu.</p><p>Informace o Vaší objednávce :</p><p>číslo objednávky: <strong>%Object(order, {"method":"getOrderId"});</strong></p><p>Objednávka:</p><p>%Text(products);</p><p>%Text(orderInfo);</p><p>Fakturační adresa:</p><p>%Text(invoiceAddress);</p><p>Dodací adresa:</p><p>%Text(deliveryAddress);</p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					24, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>V systému byl založen nový kontaktní formulář s klíčem <strong><a href="%Text(deeplink);">%Object(form, {"method":"getKey"});</a></strong>. Obsah:</p><p>Jméno: %Object(form, {"method":"getFullName"});</p><p>E-mail: %Object(form, {"method":"getEmail"});</p><p>Telefon: %Object(form, {"method":"getPhone"});</p><p>Zpráva: %Object(form, {"method":"getMessage"});</p><p>Pimshop</p>',
					33, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za nákup v našem e-shopu.</p><p>Informace o Vaší objednávce :</p><p>číslo objednávky: <strong>%Object(order, {"method":"getOrderId"});</strong></p><p>Objednávka:</p><p>%Text(products);</p><p>%Text(orderInfo);</p><p>Fakturační adresa:</p><p>%Text(invoiceAddress);</p><p>Dodací adresa:</p><p>%Text(deliveryAddress);</p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					34, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za nákup v našem e-shopu.</p><p>Informace o Vaší objednávce :</p><p>číslo objednávky: <strong>%Object(order, {"method":"getOrderId"});</strong></p><p>Objednávka:</p><p>%Text(products);</p><p>%Text(orderInfo);</p><p>Fakturační adresa:</p><p>%Text(invoiceAddress);</p><p>Dodací adresa:</p><p>%Text(deliveryAddress);</p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					35, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za nákup v našem e-shopu.</p><p>Informace o Vaší objednávce :</p><p>číslo objednávky: <strong>%Object(order, {"method":"getOrderId"});</strong></p><p>Objednávka:</p><p>%Text(products);</p><p>%Text(orderInfo);</p><p>Fakturační adresa:</p><p>%Text(invoiceAddress);</p><p>Dodací adresa:</p><p>%Text(deliveryAddress);</p><p><strong><i>Platební informace:</i></strong></p><p><strong>Číslo účtu: </strong>%Text(bankAccountNumber);</p><p><strong>Variabilní symbol: %Object(order, {"method":"getOrderId"});</strong></p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					36, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za nákup v našem e-shopu.</p><p>Informace o Vaší objednávce :</p><p>číslo objednávky: <strong>%Object(order, {"method":"getOrderId"});</strong></p><p>Objednávka:</p><p>%Text(products);</p><p>%Text(orderInfo);</p><p>Fakturační adresa:</p><p>%Text(invoiceAddress);</p><p>Dodací adresa:</p><p>%Text(deliveryAddress);</p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					37, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Vaše objednávka č.<strong>%Object(order, {"method":"getOrderId"});</strong> byla dnes připravena k vyzvednutí na prodejně.</p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					38, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Vaše objednávka č.<strong>%Object(order, {"method":"getOrderId"});</strong> byla dnes předána přepravci.</p><p>Sledovací číslo zásilky: <strong>%Object(order, {"method":"getTrackingNumber"});</strong></p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					39, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Vaše objednávka č.<strong>%Object(order, {"method":"getOrderId"});</strong> byla dnes předána přepravci.</p><p>Sledovací číslo zásilky: <strong>%Object(order, {"method":"getTrackingNumber"});</strong></p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>',
					40, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Vaše objednávka č.<strong>%Object(order, {"method":"getOrderId"});</strong> byla dnes předána přepravci.</p><p>Adresa odběrného místa: <strong>%Object(order, {"method":"getUlozenkaAddress"});</strong></p><p>Těšíme se na Váš další nákup</p><p>Pimshop</p>'
				)
			),
			'documents_email' => array(
				'schema' => array('id', 'module', 'controller', 'action', 'template', 'to', 'from', 'cc', 'bcc', 'subject'),
				'data' => array(
					6, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - přihlášení k odběru newsletteru',
					14, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - dokončení registrace',
					15, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - automatická registrace',
					16, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - reset hesla',
					18, '', 'snippet', 'simple-mail', '', 'noreply@vm3.portadesign.cz', 'noreply@portadesign.cz', '', '', 'Pimshop - notifikace: nová objednávka',
					19, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Potvrzení objednávky',
					24, '', 'snippet', 'simple-mail', '', 'noreply@vm3.portadesign.cz', 'noreply@portadesign.cz', '', '', 'Pimshop - notifikace: nový kontaktní formulář',
					33, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Potvrzení objednávky',
					34, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Potvrzení objednávky',
					35, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Potvrzení objednávky',
					36, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Potvrzení objednávky',
					37, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Vyřízení objednávky',
					38, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Vyřízení objednávky',
					39, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Vyřízení objednávky',
					40, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimshop - Vyřízení objednávky'
				)
			),
			'documents_page' => array(
				'schema' => array('id', 'module', 'controller', 'action', 'template', 'title', 'description', 'keywords', 'metaData', 'prettyUrl', 'contentMasterDocumentId', 'personas'),
				'data' => array(
					2, '', 'default', 'index', NULL, 'Úvod', 'Úvod', '', 'a:0:{}', '', NULL, NULL,
					7, '', 'default', 'error-page', NULL, 'Chybová stránka', '', '', '', '', NULL, NULL,
					8, '', 'cms', 'template-simple', NULL, 'O nás', 'O nás', '', 'a:0:{}', '', NULL, NULL,
					9, '', 'cms', 'contact-us', NULL, 'Kontakt', 'Kontakt', '', 'a:0:{}', '', NULL, NULL,
					10, '', 'cms', 'template-simple', NULL, 'Doprava a platba', 'Doprava a platba', '', 'a:0:{}', '', NULL, NULL,
					11, '', 'cms', 'template-simple', NULL, 'Obchodní podmínky', 'Obchodní podmínky', '', 'a:0:{}', '', NULL, NULL,
					12, '', 'user', 'account', '', 'Účet', 'Účet', '', 'a:0:{}', '', NULL, NULL,
					17, '', 'shop', 'cart', NULL, 'Košík', 'Košík', '', 'a:0:{}', '', NULL, NULL,
					20, '', 'shop', 'compare-products', NULL, 'Porovnání produktů', 'Porovnání produktů', '', 'a:0:{}', '', NULL, NULL,
					21, '', 'cms', 'sitemap', NULL, 'Mapa stránek', 'Mapa stránek', '', 'a:0:{}', '', NULL, NULL,
					22, '', 'cms', 'news', NULL, 'Aktuality', 'Aktuality', '', 'a:0:{}', '', NULL, NULL,
					25, '', 'shop', 'products', NULL, 'Produkty', 'Produkty', '', 'a:0:{}', '', NULL, NULL,
					26, '', 'user', 'login', NULL, 'Přihlášení', 'Přihlášení', '', 'a:0:{}', '', NULL, NULL,
					27, '', 'cms', 'search-results', NULL, 'Výsledky vyhledávání', 'Výsledky vyhledávání', '', 'a:0:{}', '', NULL, NULL,
					28, '', 'user', 'change-password', NULL, 'Změna hesla', 'Změna hesla', '', 'a:0:{}', '', NULL, NULL,
					29, '', 'user', 'orders', NULL, 'Objednávky', 'Objednávky', '', 'a:0:{}', '', NULL, NULL,
					30, '', 'user', 'profile', NULL, 'Profil', 'Profil', '', 'a:0:{}', '', NULL, NULL,
					31, '', 'shop', 'cart-info', NULL, 'Kontaktní a platební údaje', 'Kontaktní a platební údaje', '', 'a:0:{}', '', NULL, NULL,
					32, '', 'shop', 'cart-summary', NULL, 'Rekapitulace', 'Rekapitulace', '', 'a:0:{}', '', NULL, NULL
				)
			),
			'objects' => array(
				'schema' => array('o_id', 'o_parentId', 'o_type', 'o_key', 'o_path', 'o_index', 'o_published', 'o_creationDate', 'o_modificationDate', 'o_userOwner', 'o_userModification', 'o_classId', 'o_className'),
				'data' => array(
					2, 7, 'folder', 'katalog', '/eshop/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					3, 15, 'folder', 'novinky', '/novinky', 0, 1, $time, $time, 2, 2, NULL, NULL,
					4, 1, 'folder', 'kontakt', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					5, 4, 'folder', 'kontaktni-formulare', '/kontakt/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					6, 4, 'folder', 'newsletter', '/kontakt/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					7, 1, 'folder', 'eshop', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					8, 10, 'folder', 'objednavky', '/prodeje/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					9, 7, 'folder', 'slevove-kody', '/eshop/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					10, 1, 'folder', 'prodeje', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					11, 7, 'folder', 'prodejni-akce', '/eshop/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					12, 7, 'object', 'eshop_settings', '/', 0, 1, $time, $time, 2, 2, 9, 'EshopSettings',
					13, 14, 'folder', 'uzivatele', '/uzivatele/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					14, 1, 'folder', 'uzivatele', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					15, 1, 'folder', 'novinky', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					16, 7, 'folder', 'atributy-variant', '/eshop/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					17, 16, 'folder', 'barvy', '/eshop/atributy-variant/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					18, 16, 'folder', 'velikosti', '/eshop/atributy-variant/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					19, 7, 'folder', 'znacky', '/eshop/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					20, 13, 'object', 'john.doe_at_example.com', '/uzivatele/uzivatele/', 0, 1, $time, $time, 2, 2, 10, 'User',
					21, 17, 'object', 'bila', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					22, 17, 'object', 'cerna', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					23, 17, 'object', 'cervena', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					24, 17, 'object', 'oranzova', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					25, 17, 'object', 'zluta', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					26, 17, 'object', 'zelena', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					27, 17, 'object', 'modra', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					28, 17, 'object', 'fialova', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					29, 17, 'object', 'hneda', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					30, 17, 'object', 'ruzova', '/eshop/atributy-variant/barvy/', 0, 1, $time, $time, 2, 2, 11, 'ProductColor',
					31, 18, 'object', 's', '/eshop/atributy-variant/velikosti/', 0, 1, $time, $time, 2, 2, 12, 'ProductSize',
					32, 18, 'object', 'm', '/eshop/atributy-variant/velikosti/', 0, 1, $time, $time, 2, 2, 12, 'ProductSize',
					33, 18, 'object', 'l', '/eshop/atributy-variant/velikosti/', 0, 1, $time, $time, 2, 2, 12, 'ProductSize',
					34, 18, 'object', 'xl', '/eshop/atributy-variant/velikosti/', 0, 1, $time, $time, 2, 2, 12, 'ProductSize',
					35, 18, 'object', 'xxl', '/eshop/atributy-variant/velikosti/', 0, 1, $time, $time, 2, 2, 12, 'ProductSize'
				)
			),
			//eshop settings
			'object_query_9' => array(
				'schema' => array('oo_id', 'oo_classId', 'oo_className', 'vatHigh', 'vatLow', 'exchangeRate__cs_cz#rate', 'exchangeRate__cs_cz#isdefault', 'exchangeRate__cs_cz#isactive', 'exchangeRate__sk_sk#rate', 'exchangeRate__sk_sk#isdefault', 'exchangeRate__sk_sk#isactive', 'supplierName', 'supplierStreet', 'supplierCity', 'supplierZip', 'supplierIco', 'supplierDic', 'invoiceTitle', 'supplierAccountNumber', 'supplierIsTaxPayer', 'supplierStamp__image', 'supplierStamp__hotspots', 'outOfStockBehaviour', 'productPageLimit', 'dailyCost', 'showVariantsInLists', 'shippingOptionsCZ__cz#shipping_pick_up', 'shippingOptionsCZ__cz#shipping_czech_ppl', 'shippingOptionsCZ__cz#shipping_czech_post', 'shippingOptionsCZ__cz#shipping_ulozenka', 'paymentOptionsCZ__shipping_pick_up#payment_cash', 'paymentOptionsCZ__shipping_pick_up#payment_cod', 'paymentOptionsCZ__shipping_pick_up#payment_bank_transfer', 'paymentOptionsCZ__shipping_pick_up#payment_credit_card', 'paymentOptionsCZ__shipping_czech_ppl#payment_cash', 'paymentOptionsCZ__shipping_czech_ppl#payment_cod', 'paymentOptionsCZ__shipping_czech_ppl#payment_bank_transfer', 'paymentOptionsCZ__shipping_czech_ppl#payment_credit_card', 'paymentOptionsCZ__shipping_czech_post#payment_cash', 'paymentOptionsCZ__shipping_czech_post#payment_cod', 'paymentOptionsCZ__shipping_czech_post#payment_bank_transfer', 'paymentOptionsCZ__shipping_czech_post#payment_credit_card', 'paymentOptionsCZ__shipping_ulozenka#payment_cash', 'paymentOptionsCZ__shipping_ulozenka#payment_cod', 'paymentOptionsCZ__shipping_ulozenka#payment_bank_transfer', 'paymentOptionsCZ__shipping_ulozenka#payment_credit_card', 'shippingDiscountOptionsCZ__step1#price', 'shippingDiscountOptionsCZ__step1#discount', 'shippingDiscountOptionsCZ__step1#ispercentual', 'shippingDiscountOptionsCZ__step2#price', 'shippingDiscountOptionsCZ__step2#discount', 'shippingDiscountOptionsCZ__step2#ispercentual', 'shippingDiscountOptionsCZ__step3#price', 'shippingDiscountOptionsCZ__step3#discount', 'shippingDiscountOptionsCZ__step3#ispercentual', 'shippingDiscountOptionsCZ__step4#price', 'shippingDiscountOptionsCZ__step4#discount', 'shippingDiscountOptionsCZ__step4#ispercentual', 'shippingOptionsSK__sk#shipping_pick_up', 'shippingOptionsSK__sk#shipping_ulozenka', 'paymentOptionsSK__shipping_pick_up#payment_cash', 'paymentOptionsSK__shipping_pick_up#payment_credit_card', 'paymentOptionsSK__shipping_ulozenka#payment_cash', 'paymentOptionsSK__shipping_ulozenka#payment_credit_card', 'shippingDiscountOptionsSK__step1#price', 'shippingDiscountOptionsSK__step1#discount', 'shippingDiscountOptionsSK__step1#ispercentual', 'shippingDiscountOptionsSK__step2#price', 'shippingDiscountOptionsSK__step2#discount', 'shippingDiscountOptionsSK__step2#ispercentual', 'shippingDiscountOptionsSK__step3#price', 'shippingDiscountOptionsSK__step3#discount', 'shippingDiscountOptionsSK__step3#ispercentual', 'shippingDiscountOptionsSK__step4#price', 'shippingDiscountOptionsSK__step4#discount', 'shippingDiscountOptionsSK__step4#ispercentual', 'shippingCostOptionsCZ__payment_cash#shipping_pick_up', 'shippingCostOptionsCZ__payment_cash#shipping_czech_post', 'shippingCostOptionsCZ__payment_cash#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_cash#shipping_ulozenka', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_pick_up', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_post', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_ulozenka', 'shippingCostOptionsCZ__payment_credit_card#shipping_pick_up', 'shippingCostOptionsCZ__payment_credit_card#shipping_czech_post', 'shippingCostOptionsCZ__payment_credit_card#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_credit_card#shipping_ulozenka', 'shippingCostOptionsCZ__payment_cod#shipping_pick_up', 'shippingCostOptionsCZ__payment_cod#shipping_czech_post', 'shippingCostOptionsCZ__payment_cod#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_cod#shipping_ulozenka', 'shippingCostOptionsSK__payment_cash#shipping_pick_up', 'shippingCostOptionsSK__payment_cash#shipping_ulozenka', 'shippingCostOptionsSK__payment_credit_card#shipping_pick_up', 'shippingCostOptionsSK__payment_credit_card#shipping_ulozenka', 'exchangeRateShadow'),
				'data' => array(
					12, 9, 'EshopSettings', 21, 15, 1, 1, 1, 27.4, 0, 1, 'Pimshop', 'Soukopova 15', 'Brno', '60200', '1234', '12312', 'Faktura č.', '123124-12323', 1, NULL, NULL, 'block', 12, 10, 1, 0, 90, 120, 30, 0, -1, 0, 0, -1, 30, 0, 0, 0, 30, 0, 0, 0, -1, 0, 0, 500, 50, 0, 1000, 100, 1, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 15, 50, 1, 30, 100, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
				)
			),
			'object_store_9' => array(
				'schema' => array('oo_id', 'vatHigh', 'vatLow', 'exchangeRate__cs_cz#rate', 'exchangeRate__cs_cz#isdefault', 'exchangeRate__cs_cz#isactive', 'exchangeRate__sk_sk#rate', 'exchangeRate__sk_sk#isdefault', 'exchangeRate__sk_sk#isactive', 'supplierName', 'supplierStreet', 'supplierCity', 'supplierZip', 'supplierIco', 'supplierDic', 'invoiceTitle', 'supplierAccountNumber', 'supplierIsTaxPayer', 'supplierStamp__image', 'supplierStamp__hotspots', 'outOfStockBehaviour', 'productPageLimit', 'dailyCost', 'showVariantsInLists', 'shippingOptionsCZ__cz#shipping_pick_up', 'shippingOptionsCZ__cz#shipping_czech_ppl', 'shippingOptionsCZ__cz#shipping_czech_post', 'shippingOptionsCZ__cz#shipping_ulozenka', 'paymentOptionsCZ__shipping_pick_up#payment_cash', 'paymentOptionsCZ__shipping_pick_up#payment_cod', 'paymentOptionsCZ__shipping_pick_up#payment_bank_transfer', 'paymentOptionsCZ__shipping_pick_up#payment_credit_card', 'paymentOptionsCZ__shipping_czech_ppl#payment_cash', 'paymentOptionsCZ__shipping_czech_ppl#payment_cod', 'paymentOptionsCZ__shipping_czech_ppl#payment_bank_transfer', 'paymentOptionsCZ__shipping_czech_ppl#payment_credit_card', 'paymentOptionsCZ__shipping_czech_post#payment_cash', 'paymentOptionsCZ__shipping_czech_post#payment_cod', 'paymentOptionsCZ__shipping_czech_post#payment_bank_transfer', 'paymentOptionsCZ__shipping_czech_post#payment_credit_card', 'paymentOptionsCZ__shipping_ulozenka#payment_cash', 'paymentOptionsCZ__shipping_ulozenka#payment_cod', 'paymentOptionsCZ__shipping_ulozenka#payment_bank_transfer', 'paymentOptionsCZ__shipping_ulozenka#payment_credit_card', 'shippingDiscountOptionsCZ__step1#price', 'shippingDiscountOptionsCZ__step1#discount', 'shippingDiscountOptionsCZ__step1#ispercentual', 'shippingDiscountOptionsCZ__step2#price', 'shippingDiscountOptionsCZ__step2#discount', 'shippingDiscountOptionsCZ__step2#ispercentual', 'shippingDiscountOptionsCZ__step3#price', 'shippingDiscountOptionsCZ__step3#discount', 'shippingDiscountOptionsCZ__step3#ispercentual', 'shippingDiscountOptionsCZ__step4#price', 'shippingDiscountOptionsCZ__step4#discount', 'shippingDiscountOptionsCZ__step4#ispercentual', 'shippingOptionsSK__sk#shipping_pick_up', 'shippingOptionsSK__sk#shipping_ulozenka', 'paymentOptionsSK__shipping_pick_up#payment_cash', 'paymentOptionsSK__shipping_pick_up#payment_credit_card', 'paymentOptionsSK__shipping_ulozenka#payment_cash', 'paymentOptionsSK__shipping_ulozenka#payment_credit_card', 'shippingDiscountOptionsSK__step1#price', 'shippingDiscountOptionsSK__step1#discount', 'shippingDiscountOptionsSK__step1#ispercentual', 'shippingDiscountOptionsSK__step2#price', 'shippingDiscountOptionsSK__step2#discount', 'shippingDiscountOptionsSK__step2#ispercentual', 'shippingDiscountOptionsSK__step3#price', 'shippingDiscountOptionsSK__step3#discount', 'shippingDiscountOptionsSK__step3#ispercentual', 'shippingDiscountOptionsSK__step4#price', 'shippingDiscountOptionsSK__step4#discount', 'shippingDiscountOptionsSK__step4#ispercentual', 'shippingCostOptionsCZ__payment_cash#shipping_pick_up', 'shippingCostOptionsCZ__payment_cash#shipping_czech_post', 'shippingCostOptionsCZ__payment_cash#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_cash#shipping_ulozenka', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_pick_up', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_post', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_bank_transfer#shipping_ulozenka', 'shippingCostOptionsCZ__payment_credit_card#shipping_pick_up', 'shippingCostOptionsCZ__payment_credit_card#shipping_czech_post', 'shippingCostOptionsCZ__payment_credit_card#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_credit_card#shipping_ulozenka', 'shippingCostOptionsCZ__payment_cod#shipping_pick_up', 'shippingCostOptionsCZ__payment_cod#shipping_czech_post', 'shippingCostOptionsCZ__payment_cod#shipping_czech_ppl', 'shippingCostOptionsCZ__payment_cod#shipping_ulozenka', 'shippingCostOptionsSK__payment_cash#shipping_pick_up', 'shippingCostOptionsSK__payment_cash#shipping_ulozenka', 'shippingCostOptionsSK__payment_credit_card#shipping_pick_up', 'shippingCostOptionsSK__payment_credit_card#shipping_ulozenka', 'exchangeRateShadow'),
				'data' => array(
					12, 21, 15, 1, 1, 1, 27.4, 0, 1, 'Pimshop', 'Soukopova 15', 'Brno', '60200', '1234', '12312', 'Faktura č.', '123124-12323', 1, NULL, NULL, 'block', 12, 10, 1, 0, 90, 120, 30, 0, -1, 0, 0, -1, 30, 0, 0, 0, 30, 0, 0, 0, -1, 0, 0, 500, 50, 0, 1000, 100, 1, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 15, 50, 1, 30, 100, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
				)
			),
			//john doe user
			'object_query_10' => array(
				'schema' => array('oo_id', 'oo_classId', 'oo_className', 'email', 'password', 'activationCode', 'lang', 'firstName', 'lastName', 'phone', 'street', 'city', 'zipCode', 'company', 'ico', 'dic'),
				'data' => array(
					20, 10, 'User', 'john.doe@example.com', 'pass', 'not important...', 'cs', 'John', 'Doe', '0987654321', 'Street', 'City', '13456', 'Company', 'ico', 'dic'
				)
			),
			'object_store_10' => array(
				'schema' => array('oo_id', 'email', 'password', 'activationCode', 'lang', 'firstName', 'lastName', 'phone', 'street', 'city', 'zipCode', 'company', 'ico', 'dic'),
				'data' => array(
					20, 'john.doe@example.com', 'pass', 'not important...', 'cs', 'John', 'Doe', '0987654321', 'Street', 'City', '13456', 'Company', 'ico', 'dic'
				)
			),
			//product colors
			'object_localized_data_11' => array(
				'schema' => array('ooo_id', 'language', 'name'),
				'data' => array(
					21, 'cs', 'Bílá',
					22, 'cs', 'Černá',
					23, 'cs', 'Červená',
					24, 'cs', 'Oranžová',
					25, 'cs', 'Žlutá',
					26, 'cs', 'Zelená',
					27, 'cs', 'Modrá',
					28, 'cs', 'Fialová',
					29, 'cs', 'Hnědá',
					30, 'cs', 'Růžová'
				)
			),
			'object_localized_query_11_cs' => array(
				'schema' => array('ooo_id', 'language', 'name'),
				'data' => array(
					21, 'cs', 'Bílá',
					22, 'cs', 'Černá',
					23, 'cs', 'Červená',
					24, 'cs', 'Oranžová',
					25, 'cs', 'Žlutá',
					26, 'cs', 'Zelená',
					27, 'cs', 'Modrá',
					28, 'cs', 'Fialová',
					29, 'cs', 'Hnědá',
					30, 'cs', 'Růžová'
				)
			),
			'object_store_11' => array(
				'schema' => array('oo_id'),
				'data' => array(
					21, 22, 23, 24, 25, 26, 27, 28, 29, 30
				)
			),
			'object_query_11' => array(
				'schema' => array('oo_id', 'oo_classId', 'oo_className'),
				'data' => array(
					21, 11, 'ProductColor',
					22, 11, 'ProductColor',
					23, 11, 'ProductColor',
					24, 11, 'ProductColor',
					25, 11, 'ProductColor',
					26, 11, 'ProductColor',
					27, 11, 'ProductColor',
					28, 11, 'ProductColor',
					29, 11, 'ProductColor',
					30, 11, 'ProductColor'
				)
			),
			//product sizes
			'object_localized_data_12' => array(
				'schema' => array('ooo_id', 'language', 'name'),
				'data' => array(
					31, 'cs', 'S',
					32, 'cs', 'M',
					33, 'cs', 'L',
					34, 'cs', 'XL',
					35, 'cs', 'XXL'
				)
			),
			'object_localized_query_12_cs' => array(
				'schema' => array('ooo_id', 'language', 'name'),
				'data' => array(
					31, 'cs', 'S',
					32, 'cs', 'M',
					33, 'cs', 'L',
					34, 'cs', 'XL',
					35, 'cs', 'XXL'
				)
			),
			'object_store_12' => array(
				'schema' => array('oo_id'),
				'data' => array(
					31, 32, 33, 34, 35
				)
			),
			'object_query_12' => array(
				'schema' => array('oo_id', 'oo_classId', 'oo_className'),
				'data' => array(
				31, 12, 'ProductSize',
				32, 12, 'ProductSize',
				33, 12, 'ProductSize',
				34, 12, 'ProductSize',
				35, 12, 'ProductSize'
				)
			),
			'properties' => array(
				'schema' => array('cid', 'ctype', 'cpath', 'name', 'type', 'data', 'inheritable'),
				'data' => array(
					1, 'document', '/', 'language', 'text', 'cs', 1,
					1, 'document', '/', 'titlePostfix', 'text', 'Pimshop', 1,
					1, 'document', '/', 'titleSeparator', 'text', ' - ', 1,
					2, 'document', '/cs', 'language', 'text', 'cs', 1,
					2, 'document', '/cs', 'navigation_name', 'text', 'Úvod', 0,
					2, 'document', '/cs', 'navigation_title', 'text', 'Úvod', 0,
					8, 'document', '/cs/o-nas', 'navigation_name', 'text', 'O nás', 0,
					8, 'document', '/cs/o-nas', 'navigation_title', 'text', 'O nás', 0,
					9, 'document', '/cs/kontakt', 'navigation_name', 'text', 'Kontakt', 0,
					9, 'document', '/cs/kontakt', 'navigation_title', 'text', 'Kontakt', 0,
					10, 'document', '/cs/doprava-a-platba', 'navigation_name', 'text', 'Doprava a platba', 0,
					10, 'document', '/cs/doprava-a-platba', 'navigation_title', 'text', 'Doprava a platba', 0,
					11, 'document', '/cs/obchodni-podminky', 'navigation_name', 'text', 'Obchodní podmínky', 0,
					11, 'document', '/cs/obchodni-podminky', 'navigation_title', 'text', 'Obchodní podmínky', 0,
					12, 'document', '/cs/ucet', 'navigation_name', 'text', 'Účet', 0,
					12, 'document', '/cs/ucet', 'navigation_title', 'text', 'Účet', 0,
					12, 'document', '/cs/ucet', 'elastic_search_exclude', 'bool', '1', 1,
					17, 'document', '/cs/kosik', 'navigation_name', 'text', 'Košík', 0,
					17, 'document', '/cs/kosik', 'navigation_title', 'text', 'Košík', 0,
					17, 'document', '/cs/kosik', 'elastic_search_exclude', 'bool', '1', 1,
					20, 'document', '/cs/porovnani-produktu', 'navigation_name', 'text', 'Porovnání produktů', 0,
					20, 'document', '/cs/porovnani-produktu', 'navigation_title', 'text', 'Porovnání produktů', 0,
					20, 'document', '/cs/porovnani-produktu', 'elastic_search_exclude', 'bool', '1', 0,
					21, 'document', '/cs/mapa-stranek', 'navigation_name', 'text', 'Mapa stránek', 0,
					21, 'document', '/cs/mapa-stranek', 'navigation_title', 'text', 'Mapa stránek', 0,
					22, 'document', '/cs/aktuality', 'navigation_name', 'text', 'Aktuality', 0,
					22, 'document', '/cs/aktuality', 'navigation_title', 'text', 'Aktuality', 0,
					25, 'document', '/cs/produkty', 'navigation_name', 'text', 'Produkty', 0,
					25, 'document', '/cs/produkty', 'navigation_title', 'text', 'Produkty', 0,
					26, 'document', '/cs/prihlaseni', 'navigation_name', 'text', 'Přihlášení', 0,
					26, 'document', '/cs/prihlaseni', 'navigation_title', 'text', 'Přihlášení', 0,
					27, 'document', '/cs/vysledky-vyhledavani', 'elastic_search_exclude', 'bool', '1', 0,
					27, 'document', '/cs/vysledky-vyhledavani', 'navigation_name', 'text', 'Výsledky vyhledávání', 0,
					27, 'document', '/cs/vysledky-vyhledavani', 'navigation_title', 'text', 'Výsledky vyhledávání', 0,
					28, 'document', '/cs/ucet/zmena-hesla', 'navigation_name', 'text', 'Změna hesla', 0,
					28, 'document', '/cs/ucet/zmena-hesla', 'navigation_title', 'text', 'Změna hesla', 0,
					29, 'document', '/cs/ucet/objednavky', 'navigation_name', 'text', 'Objednávky', 0,
					29, 'document', '/cs/ucet/objednavky', 'navigation_title', 'text', 'Objednávky', 0,
					30, 'document', '/cs/ucet/profil', 'navigation_name', 'text', 'Profil', 0,
					30, 'document', '/cs/ucet/profil', 'navigation_title', 'text', 'Profil', 0,
					31, 'document', '/cs/kosik/kontaktni-a-platebni-udaje', 'navigation_name', 'text', 'Kontaktní a platební údaje', 0,
					31, 'document', '/cs/kosik/kontaktni-a-platebni-udaje', 'navigation_title', 'text', 'Kontaktní a platební údaje', 0,
					32, 'document', '/cs/kosik/kontaktni-a-platebni-udaje/rekapitulace', 'navigation_name', 'text', 'Rekapitulace', 0,
					32, 'document', '/cs/kosik/kontaktni-a-platebni-udaje/rekapitulace', 'navigation_title', 'text', 'Rekapitulace', 0
				)
			),
			'properties_predefined' => array(
				'schema' => array('id', 'name', 'description', 'key', 'type', 'data', 'config', 'ctype', 'inheritable', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'Mail sender name', '', 'emailSender', 'text', NULL, NULL, 'document', 1, $time, $time,
					2, 'Exclude from Elastic Search', '', 'elastic_search_exclude', 'bool', 'true', '', 'document', 0, $time, $time
				)
			),
			'staticroutes' => array(
				'schema' => array('id', 'name', 'pattern', 'reverse', 'module', 'controller', 'action', 'variables', 'defaults', 'siteId', 'priority', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'newsletter-subscribe', '#/(cs)/newsletter-subscribe#', '/%language/newsletter-subscribe', '', 'cms', 'newsletter-subscribe', 'language', NULL, NULL, 3, $time, $time,
					2, 'newsletter-unsubscribe', '#/(cs)/newsletter-unsubscribe/([a-z0-9]+)#', '/%language/newsletter-unsubscribe/%code', NULL, 'cms', 'newsletter-unsubscribe', 'language,code', '', NULL, 3, $time, $time,
					4, 'news-cs', '#/cs/aktuality/([0-9]+)-([a-z0-9-]+)#', '/cs/aktuality/%id-%slug', '', 'cms', 'news-detail', 'id,slug', '', NULL, 3, $time, $time,
					5, 'product-cs', '#/cs/([a-z0-9-/]+)#', '/cs/%translatedPath', '', 'shop', 'product', 'translatedPath', '', NULL, 1, $time, $time,
					6, 'activate-account', '#/(cs)/activate-account/([a-z0-9]+)#', '/%language/activate-account/%code', '', 'user', 'activation', 'laguage,code', '', NULL, 3, $time, $time,
					7, 'logout', '#/(cs)/logout#', '/%language/logout', '', 'user', 'logout', '', NULL, NULL, 3, $time, $time,
					8, 'add-to-cart', '#/(cs)/add-to-cart/([0-9]+)/([0-9]+)#', '/%language/add-to-cart/%id/%count', '', 'shop', 'add-to-cart', 'language,id,count', '', NULL, 3, $time, $time,
					9, 'change-locale', '#/(cs)/change-locale/([a-zA-Z_]+)#', '/%language/change-locale/%locale', '', 'default', 'change-locale', 'language,locale', '', NULL, 3, $time, $time,
					10, 'modify-comparison', '#/(cs)/modify-product-comparison/([0-9]+)/([0-9]{1})/([0-9]+)#', '/%language/modify-product-comparison/%id/%remove/%context', '', 'shop', 'modify-comparison', 'language,id,remove,context', NULL, NULL, 3, $time, $time,
					11, 'invoice-cs', '#/cs/ucet/objednavky/([0-9]+)/faktura#', '/cs/ucet/objednavky/%id/faktura', '', 'shop', 'invoice', 'id', '', NULL, 3, $time, $time,
					12, 'order-cs', '#/cs/ucet/objednavky/([0-9]+)#', '/cs/ucet/objednavky/%id', NULL, 'user', 'order', 'id', '', NULL, 3, $time, $time,
					13, 'gpe-webpay', '#/(cs)/e-commerce/gpe/landing#', '/%language/e-commerce/gpe/landing', NULL, 'ecommerce', 'gpe-webpay', 'language', '', NULL, 3, $time, $time,
					14, 'gpe-webpay-gate', '#/(cs)/e-commerce/gpe/gate#', '/%language/e-commerce/gpe/gate', NULL, 'ecommerce', 'gpe-webpay-gate', 'language', '', NULL, 3, $time, $time,
					15, 'password-reset', '#/(cs)/password-reset/([a-z0-9]+)#', '/%language/password-reset/%token', '', 'user', 'password-reset', 'language,token', '', NULL, 4, $time, $time,
					16, 'autocomplete', '#/(cs)/autocomplete/(.*)#', '/%language/autocomplete/%query', '', 'shop', 'autocomplete', 'language,query', '', NULL, 4, $time, $time,
					17, 'sitemap-xml', '#/sitemap.xml#', '/sitemap.xml', '', 'default', 'sitemap-xml', '', NULL, NULL, 4, $time, $time,
					18, 'download-asset', '#/download-asset/([0-9]+)#', '/download-asset/%id', '', 'default', 'download-asset', 'language,id', NULL, NULL, 4, $time, $time
				)
			),
			/*
			'tree_locks' => array(
				'schema' => array('id', 'type', 'locked'),
				'data' => array(
					2, 'asset', 'self',
					2, 'document', 'self',
					2, 'object', 'self',
					3, 'asset', 'self',
					3, 'document', 'self',
					3, 'object', 'self',
					4, 'asset', 'self',
					4, 'object', 'self',
					5, 'asset', 'self',
					5, 'document', 'self',
					5, 'object', 'self',
					6, 'asset', 'self',
					6, 'document', 'self',
					6, 'object', 'self',
					7, 'document', 'self',
					7, 'object', 'self',
					8, 'document', 'self',
					8, 'object', 'self',
					9, 'asset', 'self',
					9, 'document', 'self',
					9, 'object', 'self',
					10, 'asset', 'self',
					10, 'document', 'self',
					10, 'object', 'self',
					11, 'document', 'self',
					11, 'object', 'self',
					12, 'document', 'self',
					12, 'object', 'self',
					13, 'asset', 'self',
					13, 'object', 'self',
					14, 'document', 'self',
					14, 'asset', 'self',
					14, 'object', 'self',
					15, 'document', 'self',
					15, 'object', 'self',
					16, 'document', 'self',
					16, 'object', 'self',
					17, 'document', 'self',
					17, 'object', 'self',
					18, 'document', 'self',
					18, 'object', 'self',
					19, 'document', 'self',
					19, 'object', 'self',
					20, 'document', 'self',
					20, 'object', 'self',
					21, 'document', 'self',
					22, 'document', 'self',
					24, 'document', 'self',
					25, 'document', 'self',
					26, 'document', 'self',
					27, 'document', 'self',
					28, 'document', 'self',
					29, 'document', 'self',
					30, 'document', 'self',
					31, 'document', 'self',
					32, 'document', 'self',
					33, 'document', 'self',
					34, 'document', 'self',
					35, 'document', 'self',
					36, 'document', 'self',
					37, 'document', 'self',
					38, 'document', 'self',
					39, 'document', 'self',
					40, 'document', 'self'
				)
			),
			 * 
			 */
			'users' => array(
				'schema' => array('id', 'parentId', 'type', 'name', 'password', 'firstname', 'lastname', 'email', 'language', 'contentLanguages', 'admin', 'active', 'permissions', 'roles', 'welcomescreen', 'closeWarning', 'memorizeTabs', 'docTypes', 'classes', 'apiKey'),
				'data' => array(
					3, 0, 'role', 'editor', NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 'assets,clear_cache,dashboards,documents,emails,notes_events,objects,recyclebin,translations', NULL, NULL, NULL, NULL, '1', '1,2,3,4,5,6,7,8,9,10,11,12,14', NULL,
					4, 0, 'user', 'editor', 'b313b466e0fadc09494b1c6855b2ced5', '', '', '', 'cs', 'cs', 0, 1, '', '3', 0, 1, NULL, NULL, NULL, NULL
				)
			),
			'users_workspaces_asset' => array(
				'schema' => array('cid', 'cpath', 'userId', 'list', 'view', 'publish', 'delete', 'rename', 'create', 'settings', 'versions', 'properties'),
				'data' => array(
					1, '/', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1
				)
			),
			'users_workspaces_document' => array(
				'schema' => array('cid', 'cpath', 'userId', 'list', 'view', 'save', 'publish', 'unpublish', 'delete', 'rename', 'create', 'settings', 'versions', 'properties'),
				'data' => array(
					1, '/cs', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
				)
			),
			'users_workspaces_object' => array(
				'schema' => array('cid', 'cpath', 'userId', 'list', 'view', 'save', 'publish', 'unpublish', 'delete', 'rename', 'create', 'settings', 'versions', 'properties', 'lEdit', 'lView', 'layouts'),
				'data' => array(
					15, '/novinky', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL,
					4, '/kontakt', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL,
					7, '/eshop', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL,
					10, '/prodeje', 3, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, NULL, NULL, NULL,
					12, '/eshop_settings', 3, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, NULL, NULL, NULL,
					14, '/uzivatele', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL
				)
			),
			'translations_website' => array(
				'schema' => array('key', 'language', 'text', 'creationDate', 'modificationDate'),
				'data' => array(
					'msg_unknown_error', 'cs', 'Došlo k neznámé chybě.', $time, $time,
					'msg_invalid_request', 'cs', 'Neplatný požadavek.', $time, $time,
					'msg_invalid_token', 'cs', 'Neplatný token.', $time, $time,
					'msg_no_items_found', 'cs', 'Zadaným kritériím nevyhovují žádné položky.', $time, $time,
					'msg_cart_empty', 'cs', 'V košíku zatím nemáte žádné položky.', $time, $time,
					'msg_form_invalid', 'cs', 'Zdá se, že formulář obsahuje chyby. Zkontrolujte a zkuste ho odoslat znovu.', $time, $time,
					'msg_empty_field', 'cs', 'Pole nesmí zůstat prázdné', $time, $time,
					'msg_bad_format', 'cs', 'Údaj má nesprávný formát', $time, $time,
					'msg_bad_format_phone', 'cs', 'Zadejte prosím správné číslo telefonu s předvolbou a bez mezer (napr. +420123456789).', $time, $time,
					'msg_select_file', 'cs', 'Vyberte soubor.', $time, $time,
					'msg_not_an_image', 'cs', 'Soubor není obrázkem.', $time, $time,
					'msg_file_too_big', 'cs', 'Soubor je příliš velký.', $time, $time,
					'msg_file_not_uploaded', 'cs', 'Soubor se nepovedlo nahrát na server.', $time, $time,
					'msg_invalid_email', 'cs', 'E-mail má nesprávný formát', $time, $time,
					'msg_email_registered', 'cs', 'E-mail obsazen', $time, $time,
					'msg_email_registered_for_quick_registration', 'cs', 'Na zadaný e-mail již je vytvořen účet, přihlašte se prosím', $time, $time,
					'msg_agree_with_terms', 'cs', 'Musíte souhlasit s podmínkami', $time, $time,
					'msg_wrong_old_password', 'cs', 'Staré heslo není správné', $time, $time,
					'msg_passwords_do_not_match', 'cs', 'Hesla se neshodují', $time, $time,
					'msg_newsletter_registered', 'cs', 'E-mail %s byl zařazen do newsletteru.', $time, $time,
					'msg_newsletter_already_registered', 'cs', 'Chyba - E-mail %s již je registrován do newsletteru.', $time, $time,
					'msg_newsletter_unsubscribed', 'cs', 'E-mail %s byl odstraněn z newsletteru.', $time, $time,
					'msg_newsletter_code_invalid', 'cs', 'Chyba - neplatný kód pro odhlášení z newsletteru.', $time, $time,
					'msg_contact_form_success', 'cs', 'Kontaktní formulář byl odeslán.', $time, $time,
					'msg_registration_successfull', 'cs', 'Registrace proběhla úspěšně. Na e-mail %s byli odeslány instrukce k aktivaci Vášho účtu.', $time, $time,
					'msg_email_not_registered', 'cs', 'Chyba - E-mail %s není registrován.', $time, $time,
					'msg_account_activated', 'cs', 'Účet %s byl aktivován.', $time, $time,
					'msg_activation_code_invalid', 'cs', 'Chyba - neplatný aktivační kód.', $time, $time,
					'msg_password_reset_successfull', 'cs', 'Na registrační e-mail %s Vám byl zaslán odkaz pro změnu hesla.', $time, $time,
					'msg_password_change_successfull', 'cs', 'Heslo bylo změněno.', $time, $time,
					'msg_logout_successful', 'cs', 'Odhlášení proběhlo úspěšně.', $time, $time,
					'msg_authentication_successful', 'cs', 'Přihlášení proběhlo úspěšně.', $time, $time,
					'msg_authentication_error', 'cs', 'Neplatné přihlašovací údaje.', $time, $time,
					'msg_active_discount', 'cs', 'Aktivována sleva %s.', $time, $time,
					'msg_accept_terms', 'cs', 'Aktivována sleva %s.', $time, $time,
					'msg_quick_registration_successfull', 'cs', 'Účet na Váš e-mail <b>%s</b> byl úspěšně zřízen.', $time, $time,
					'msg_shipping_discount_current_percentual', 'cs', 'Aktivována sleva %d%% na dopravu.', $time, $time,
					'msg_shipping_discount_current', 'cs', 'Aktivována sleva %s na dopravu.', $time, $time,
					'msg_shipping_discount_next_percentual', 'cs', 'Nakupte ješte za %s a dáme Vám celkem %d%% slevu na dopravu.', $time, $time,
					'msg_shipping_discount_next', 'cs', 'Nakupte ješte za %s a dáme Vám celkem %s slevu na dopravu.', $time, $time,
					'msg_authentication_required', 'cs', 'Pro přístup do této sekce se musíte přihlásit.', $time, $time,
					'msg_out_of_stock_block', 'cs', 'Omlouváme se, ale požadovaný počet kusů produktu %s nemáme na skladu. Počet byl automaticky upraven na %d ks.', $time, $time,
					'msg_out_of_stock_inform', 'cs', 'Pozor - požadovaný počet kusů produktu %s nemáme na skladu. Může dojít k prodloužení dodací lhůty nebo zrušení objednávky. O detailech Vás budeme informovat při zpracovávaní objednávky.', $time, $time,
					'msg_cart_item_removed', 'cs', 'Produkt %s byl úspěšně odstraněn z košíku.', $time, $time,
					'msg_cart_item_removed_id', 'cs', 'Produkt s ID %d byl odstraněn z košíku. Pravděpodobně byl stažen z prodeje.', $time, $time,
					'msg_cart_item_added_to_cart', 'cs', 'Produkt %s byl přidán do košíku.', $time, $time,
					'msg_cart_item_updated', 'cs', 'Počet kusů produktu %s v košíku upraveno na %d.', $time, $time,
					'msg_cart_order_creation_error', 'cs', 'Omlouvám se, ale při vytváření objednávky došlo k chybě. Prosíme zkuste projít objednávkový proces znovu.', $time, $time,
					'msg_product_does_not_exist', 'cs', 'Omlouváme se, ale požadovaný produkt zřejmě již nemáme v ponuke.', $time, $time,
					'msg_product_comparison_full', 'cs', 'V porovnání máte maximální možný počet produktů (%d).', $time, $time,
					'msg_product_added_to_comparison', 'cs', 'Produkt %s byl přidán do porovnání.', $time, $time,
					'msg_product_already_in_comparison', 'cs', 'Produkt %s již máte v porovnání.', $time, $time,
					'msg_product_not_found', 'cs', 'Produkt nenalezen.', $time, $time,
					'msg_gpe_webpay_order_info', 'cs', 'Platba za objednavku.', $time, $time,
					'msg_gpe_webpay_response_corrupted_data', 'cs', 'Odpověď z platební brány obsahuje nevalidní data.', $time, $time,
					'msg_gpe_webpay_response_order_does_not_exist', 'cs', 'Nepodařilo se spárovat platbu s objednávkou.', $time, $time,
					'msg_gpe_webpay_response_refused_payment_reason', 'cs', 'Platební brána zamítla platbu. Důvod: <i><b>%s - %s</b></i>. Zkuste platbu opakovat. V případě nejasností nás prosím kontaktujte.', $time, $time,
					'msg_gpe_webpay_response_refused_payment', 'cs', 'Platební brána zamítla platbu. Zkuste platbu opakovat. V případě nejasností nás prosím kontaktujte.', $time, $time,
					'msg_gpe_webpay_response_paid_saved', 'cs', 'Platba proběhlá úspěšně.', $time, $time,
					'msg_gpe_webpay_response_paid_not_saved', 'cs', 'Platba proběhlá úspěšně, ale nám se nepovedlo aktualizovat stav objednávky. Prosím kontaktujte nás.', $time, $time,
					'msg_profile_changed', 'cs', 'Váš profil byl úspešně upraven.', $time, $time,
					'msg_wrong_discount_code', 'cs', 'Zadaný slevový kód je neplatný.', $time, $time,
					'label_edit', 'cs', 'Upravit', $time, $time,
					'label_first_page', 'cs', 'První stránka', $time, $time,
					'label_last_page', 'cs', 'Poslední stránka', $time, $time,
					'label_previous_page', 'cs', 'Předchozí stránka', $time, $time,
					'label_next_page', 'cs', 'Následující stránka', $time, $time,
					'label_color', 'cs', 'Barva', $time, $time,
					'label_size', 'cs', 'Velikost', $time, $time,
					'label_continue_shopping', 'cs', 'Pokračovat v nákupu', $time, $time,
					'label_add_to_cart', 'cs', 'Přidat do košíku', $time, $time,
					'label_product_count', 'cs', 'Počet kusů', $time, $time,
					'label_product_name', 'cs', 'Název produktu', $time, $time,
					'label_price_per_one', 'cs', 'Cena za kus', $time, $time,
					'label_price', 'cs', 'Cena', $time, $time,
					'label_brand', 'cs', 'Značka', $time, $time,
					'label_choose_country', 'cs', 'Vyberte krajinu', $time, $time,
					'label_country', 'cs', 'Země', $time, $time,
					'label_countryCZ', 'cs', 'Česká republika', $time, $time,
					'label_countrySK', 'cs', 'Slovensko', $time, $time,
					'label_countryAT', 'cs', 'Rakousko', $time, $time,
					'label_countryDE', 'cs', 'Německo', $time, $time,
					'label_shipping', 'cs', 'Doprava', $time, $time,
					'label_shipping_type', 'cs', 'Typ dopravy', $time, $time,
					'label_shipping_pick_up', 'cs', 'Osobní odběr', $time, $time,
					'label_shipping_czech_ppl', 'cs', 'PPL', $time, $time,
					'label_shipping_czech_post', 'cs', 'Česká pošta', $time, $time,
					'label_shipping_ulozenka', 'cs', 'Úloženka', $time, $time,
					'label_payment', 'cs', 'Platba', $time, $time,
					'label_payment_type', 'cs', 'Typ platby', $time, $time,
					'label_payment_cash', 'cs', 'Hotově', $time, $time,
					'label_payment_cod', 'cs', 'Na dobírku', $time, $time,
					'label_payment_bank_transfer', 'cs', 'Bankovním převodem', $time, $time,
					'label_payment_credit_card', 'cs', 'Platební kartou', $time, $time,
					'label_check_if_delivery_address', 'cs', 'Dodací adresa se liší od fakturační', $time, $time,
					'label_discount', 'cs', 'Sleva', $time, $time,
					'label_code', 'cs', 'Kód', $time, $time,
					'label_products_price', 'cs', 'Cena za produkty', $time, $time,
					'label_payment_price', 'cs', 'Cena za platbu', $time, $time,
					'label_shipping_price', 'cs', 'Cena za dopravu', $time, $time,
					'label_final_price', 'cs', 'Cena celkem', $time, $time,
					'label_customer_message', 'cs', 'Poznámka od nakupujícího', $time, $time,
					'label_agree_with_terms', 'cs', 'Souhlasím s <a href="/cs/obchodni-podminky" target="_blank">obchodními podmínkami</a>', $time, $time,
					'label_add_to_comparison', 'cs', 'Přidat do porovnání', $time, $time,
					'label_variant_price', 'cs', 'od %s', $time, $time,
					'label_title', 'cs', 'Název', $time, $time,
					'label_first_name', 'cs', 'Jméno', $time, $time,
					'label_last_name', 'cs', 'Příjmení', $time, $time,
					'label_phone', 'cs', 'Telefon', $time, $time,
					'label_email', 'cs', 'E-mail', $time, $time,
					'label_street', 'cs', 'Ulice', $time, $time,
					'label_city', 'cs', 'Město', $time, $time,
					'label_zip_code', 'cs', 'PSČ', $time, $time,
					'label_company', 'cs', 'Firma', $time, $time,
					'label_ico', 'cs', 'IČ', $time, $time,
					'label_dic', 'cs', 'DIČ', $time, $time,
					'label_address', 'cs', 'Adresa', $time, $time,
					'label_add', 'cs', 'Přidat', $time, $time,
					'label_submit', 'cs', 'Odeslat', $time, $time,
					'label_discount_code', 'cs', 'Slevový kód', $time, $time,
					'label_message', 'cs', 'Zpráva', $time, $time,
					'label_full_name', 'cs', 'Jméno', $time, $time,
					'label_message_text', 'cs', 'Text zprávy', $time, $time,
					'label_submit_question', 'cs', 'Odeslat dotaz', $time, $time,
					'label_pay', 'cs', 'Zaplatit', $time, $time,
					'label_password', 'cs', 'Heslo', $time, $time,
					'label_remember_me', 'cs', 'Zapamatovat', $time, $time,
					'label_login', 'cs', 'Přihlásit', $time, $time,
					'label_password_old', 'cs', 'Staré heslo', $time, $time,
					'label_password_new', 'cs', 'Nové heslo', $time, $time,
					'label_password_new_again', 'cs', 'Nove heslo znova', $time, $time,
					'label_change', 'cs', 'Změnit', $time, $time,
					'label_reset_password', 'cs', 'Resetovat heslo', $time, $time,
					'label_password_again', 'cs', 'Heslo znova', $time, $time,
					'label_newsletter', 'cs', 'Přihlásit se k odběru newsletteru', $time, $time,
					'label_send_me_newsletter', 'cs', 'Chci odebírat newsletter', $time, $time,
					'label_search', 'cs', 'Hledat', $time, $time,
					'label_register', 'cs', 'Registrovat', $time, $time,
					'label_region1', 'cs', 'Moravskoslezský', $time, $time,
					'label_region2', 'cs', 'Středočeský', $time, $time,
					'label_region3', 'cs', 'Praha', $time, $time,
					'label_region4', 'cs', 'Jihočeský', $time, $time,
					'label_region5', 'cs', 'Plzeňský', $time, $time,
					'label_region6', 'cs', 'Karlovarský', $time, $time,
					'label_region7', 'cs', 'Ústecký', $time, $time,
					'label_region8', 'cs', 'Liberecký', $time, $time,
					'label_region9', 'cs', 'Královéhradecký', $time, $time,
					'label_region10', 'cs', 'Pardubický', $time, $time,
					'label_region11', 'cs', 'Vysočina', $time, $time,
					'label_region12', 'cs', 'Jihomoravský', $time, $time,
					'label_region13', 'cs', 'Olomoucký', $time, $time,
					'label_region14', 'cs', 'Zlínský', $time, $time,
					'label_continue_with_order', 'cs', 'Pokračovat v objednávce', $time, $time,
					'label_order', 'cs', 'Objednat', $time, $time,
					'label_filter_is_new', 'cs', 'Novinky', $time, $time,
					'label_filter_is_on_sale', 'cs', 'Ve slevě', $time, $time,
					'label_query', 'cs', 'Hledaná fráze', $time, $time,
					'title_order_detail', 'cs', 'Objednávka č.%s', $time, $time,
					'title_invoice_detail', 'cs', 'Faktura', $time, $time,
					'param_page', 'cs', 'stranka', $time, $time,
					'param_search_query', 'cs', 'fraze', $time, $time,
					'param_brand', 'cs', 'znacka', $time, $time,
					'param_color', 'cs', 'barva', $time, $time,
					'param_size', 'cs', 'velikost', $time, $time,
					'param_price', 'cs', 'cena', $time, $time,
					'param_sort', 'cs', 'razeni', $time, $time,
					'param_limit', 'cs', 'limit', $time, $time,
					'system_an_error_occured', 'cs', 'Vyskytla se chyba.', $time, $time,
					'system_return_to_homepage', 'cs', 'Zpět na úvodní stránku.', $time, $time,
					'system_page_not_found', 'cs', '404 - Stránka nenalezena.', $time, $time,
					'system_application_error', 'cs', '500 - Chyba aplikace.', $time, $time
				)
			),
			'translations_admin' => array(
				'schema' => array('key', 'language', 'text', 'creationDate', 'modificationDate'),
				'data' => array(
					'account number', 'cs', 'Číslo účtu', $time, $time,
					'account number', 'en', 'Account number', $time, $time,
					'activation code', 'cs', 'Aktivační kód', $time, $time,
					'activation code', 'en', 'Activation code', $time, $time,
					'active since', 'cs', 'Aktivní od', $time, $time,
					'active since', 'en', 'Active since', $time, $time,
					'active until', 'cs', 'Aktivní do', $time, $time,
					'active until', 'en', 'Active until', $time, $time,
					'additional categories', 'cs', 'Další kategorie', $time, $time,
					'additional categories', 'en', 'Additional categories', $time, $time,
					'addresses', 'cs', 'Adresy', $time, $time,
					'addresses', 'en', 'Addresses', $time, $time,
					'apply also on shipping', 'cs', 'Aplikovat i na dopravu', $time, $time,
					'apply also on shipping', 'en', 'Apply also on shipping', $time, $time,
					'area_email', 'en', 'E-mail', $time, $time,
					'area_email', 'cs', 'E-mail', $time, $time,
					'area_email_description', 'en', ' ', $time, $time,
					'area_email_description', 'cs', ' ', $time, $time,
					'area_gallery', 'en', 'Gallery', $time, $time,
					'area_gallery', 'cs', 'Galerie', $time, $time,
					'area_gallery_description', 'en', ' ', $time, $time,
					'area_gallery_description', 'cs', ' ', $time, $time,
					'area_textblock', 'en', 'Text block', $time, $time,
					'area_textblock', 'cs', 'Text', $time, $time,
					'area_textblock_description', 'en', ' ', $time, $time,
					'area_textblock_description', 'cs', ' ', $time, $time,
					'automatic exchange rate', 'cs', 'Kurz pro automatický převod', $time, $time,
					'automatic exchange rate', 'en', 'Exchange rate', $time, $time,
					'bankovým převodem', 'cs', 'Bankovním převodem', $time, $time,
					'bankovým převodem', 'en', 'Bank transfer', $time, $time,
					'base payment price', 'cs', 'Základní cena za platbu', $time, $time,
					'base payment price', 'en', 'Base payment price', $time, $time,
					'base shipping price', 'cs', 'Základní cena za dopravu', $time, $time,
					'base shipping price', 'en', 'Base shipping price', $time, $time,
					'block purchase', 'cs', 'Blokovat nákup', $time, $time,
					'block purchase', 'en', 'Block purchase', $time, $time,
					'brand', 'cs', 'Značka', $time, $time,
					'brand', 'en', 'Brand', $time, $time,
					'canceled', 'cs', 'Zrušeno', $time, $time,
					'canceled', 'en', 'Canceled', $time, $time,
					'category', 'cs', 'Kategorie', $time, $time,
					'category', 'en', 'Category', $time, $time,
					'česká pošta', 'cs', 'Česká pošta', $time, $time,
					'česká pošta', 'en', 'Czech Post', $time, $time,
					'česká republika', 'cs', 'Česká republika', $time, $time,
					'česká republika', 'en', 'Czech republic', $time, $time,
					'česko', 'cs', 'Česká republika', $time, $time,
					'česko', 'en', 'Czech republic', $time, $time,
					'česko (czk)', 'cs', 'Česká republika (Kč)', $time, $time,
					'česko (czk)', 'en', 'Czech republic (Kč)', $time, $time,
					'city', 'cs', 'Město', $time, $time,
					'city', 'en', 'City', $time, $time,
					'classname', 'cs', 'Název třídy', $time, $time,
					'classname', 'en', 'Class name', $time, $time,
					'code', 'cs', 'Kód', $time, $time,
					'code', 'en', 'Code', $time, $time,
					'color', 'cs', 'Barva', $time, $time,
					'color', 'en', 'Color', $time, $time,
					'colors', 'cs', 'Barvy', $time, $time,
					'colors', 'en', 'Colors', $time, $time,
					'company', 'cs', 'Společnost', $time, $time,
					'company', 'en', 'Company', $time, $time,
					'complete', 'cs', 'Hotovo', $time, $time,
					'complete', 'en', 'Complete', $time, $time,
					'contact', 'cs', 'Kontakt', $time, $time,
					'contact', 'en', 'Contact', $time, $time,
					'contactform', 'cs', 'Kontaktní formulář', $time, $time,
					'contactform', 'en', 'Contact form', $time, $time,
					'content', 'cs', 'Obsah', $time, $time,
					'content', 'en', 'Content', $time, $time,
					'cost', 'cs', 'Náklady', $time, $time,
					'cost', 'en', 'Cost', $time, $time,
					'count', 'cs', 'Počet', $time, $time,
					'count', 'en', 'Count', $time, $time,
					'country', 'cs', 'Krajina', $time, $time,
					'country', 'en', 'Country', $time, $time,
					'creation date', 'cs', 'Datum vytvoření', $time, $time,
					'creation date', 'en', 'Creation date', $time, $time,
					'creationdate', 'cs', 'Datum vytvoření', $time, $time,
					'creationdate', 'en', 'Creation date', $time, $time,
					'credit note id', 'cs', 'ID dobropisu', $time, $time,
					'credit note id', 'en', 'Credit note ID', $time, $time,
					'credit note returns', 'cs', 'Počet na dobropis', $time, $time,
					'credit note returns', 'en', 'Credit note returs', $time, $time,
					'currency', 'cs', 'Měna', $time, $time,
					'currency', 'en', 'Currency', $time, $time,
					'currency settings', 'cs', 'Nastavení měny', $time, $time,
					'currency settings', 'en', 'Currency settings', $time, $time,
					'czech', 'cs', 'Čeština', $time, $time,
					'czech', 'en', 'Czech', $time, $time,
					'czk', 'cs', 'Kč', $time, $time,
					'czk', 'en', 'Kč', $time, $time,
					'daily cost', 'cs', 'Denní náklady', $time, $time,
					'daily cost', 'en', 'Daily cost', $time, $time,
					'delivery address', 'cs', 'Adresa doručení', $time, $time,
					'delivery address', 'en', 'Delivery address', $time, $time,
					'description', 'cs', 'Popisek', $time, $time,
					'description', 'en', 'Description', $time, $time,
					'dic', 'cs', 'DIČ', $time, $time,
					'dic', 'en', 'DIČ', $time, $time,
					'discount', 'cs', 'Sleva', $time, $time,
					'discount', 'en', 'Discount', $time, $time,
					'discount code', 'cs', 'Slevový kód', $time, $time,
					'discount code', 'en', 'Discount code', $time, $time,
					'discountcode', 'cs', 'Slevový kód', $time, $time,
					'discountcode', 'en', 'Discount code', $time, $time,
					'discounted price', 'cs', 'Cena po slevě', $time, $time,
					'discounted price', 'en', 'Discounted price', $time, $time,
					'due to', 'cs', 'Datum splatnosti', $time, $time,
					'due to', 'en', 'Due to', $time, $time,
					'email', 'cs', 'E-mail', $time, $time,
					'email', 'en', 'E-mail', $time, $time,
					'eshop', 'cs', 'E-shop', $time, $time,
					'eshop', 'en', 'E-shop', $time, $time,
					'eshopsettings', 'cs', 'Nastavení e-shopu', $time, $time,
					'eshopsettings', 'en', 'E-shop settings', $time, $time,
					'eur (sr)', 'cs', '€ (SR)', $time, $time,
					'eur (sr)', 'en', '€ (SR)', $time, $time,
					'eur(sr)', 'cs', '€ (SR)', $time, $time,
					'eur(sr)', 'en', '€ (SR)', $time, $time,
					'exchange rate', 'cs', 'Kurzovní lístek', $time, $time,
					'exchange rate', 'en', 'Exchange rate', $time, $time,
					'exchange rate shadow', 'cs', 'Kurzovní lístek stín', $time, $time,
					'exchange rate shadow', 'en', 'Exchange rate shadow', $time, $time,
					'filename', 'cs', 'Název souboru (složky)', $time, $time,
					'filename', 'en', 'Filename', $time, $time,
					'final price', 'cs', 'Konečná cena', $time, $time,
					'final price', 'en', 'Final price', $time, $time,
					'first name', 'cs', 'Jméno', $time, $time,
					'first name', 'en', 'First name', $time, $time,
					'firstname', 'cs', 'Jméno', $time, $time,
					'firstname', 'en', 'First name', $time, $time,
					'from store', 'cs', 'Z kamenné prodejny', $time, $time,
					'from store', 'en', 'From store', $time, $time,
					'fullpath', 'cs', 'Cesta', $time, $time,
					'fullpath', 'en', 'Full path', $time, $time,
					'general settings', 'cs', 'Obecné nastavení', $time, $time,
					'general settings', 'en', 'General settings', $time, $time,
					'gp webpay notification', 'cs', 'GP WebPay notifikace', $time, $time,
					'gp webpay notification', 'en', 'GP WebPay notification', $time, $time,
					'gp webpay timestamp', 'cs', 'GP WebPay časová známka', $time, $time,
					'gp webpay timestamp', 'en', 'GP WebPay timestamp', $time, $time,
					'hotově', 'cs', 'Hotově', $time, $time,
					'hotově', 'en', 'Cash', $time, $time,
					'ic', 'cs', 'IČ', $time, $time,
					'ic', 'en', 'IČ', $time, $time,
					'ico', 'cs', 'IČ', $time, $time,
					'ico', 'en', 'IČ', $time, $time,
					'id', 'cs', 'ID', $time, $time,
					'id', 'en', 'ID', $time, $time,
					'ignore', 'cs', 'Ignorovat', $time, $time,
					'ignore', 'en', 'Ignore', $time, $time,
					'ignore sale promotions', 'cs', 'Ignorovat globální slevy', $time, $time,
					'ignore sale promotions', 'en', 'Ignore sale promotions', $time, $time,
					'gallery', 'cs', 'Obrázky', $time, $time,
					'gallery', 'en', 'Images', $time, $time,
					'in stock', 'cs', 'Počet kusů skladem', $time, $time,
					'in stock', 'en', 'In stock', $time, $time,
					'inform', 'cs', 'Jenom informovat', $time, $time,
					'inform', 'en', 'Inform', $time, $time,
					'invoice address', 'cs', 'Fakturační adresa', $time, $time,
					'invoice address', 'en', 'Inovoice address', $time, $time,
					'invoice id', 'cs', 'ID faktury', $time, $time,
					'invoice id', 'en', 'Invoice ID', $time, $time,
					'invoice info', 'cs', 'Fakturační informace', $time, $time,
					'invoice info', 'en', 'Invoice info', $time, $time,
					'invoice settings', 'cs', 'Nastavení fakturace', $time, $time,
					'invoice settings', 'en', 'Invoice settings', $time, $time,
					'is active', 'cs', 'Aktivní', $time, $time,
					'is active', 'en', 'Is active', $time, $time,
					'is default', 'cs', 'Výchozí', $time, $time,
					'is default', 'en', 'Is default', $time, $time,
					'is low vat', 'cs', 'Snížená sazba DPH', $time, $time,
					'is low vat', 'en', 'Is low VAT', $time, $time,
					'is master product', 'cs', 'Je master produktem', $time, $time,
					'is master product', 'en', 'Is master product', $time, $time,
					'is new', 'cs', 'Novinka', $time, $time,
					'is new', 'en', 'Is new', $time, $time,
					'is percentual', 'cs', 'Procentuální', $time, $time,
					'is percentual', 'en', 'Is percentual', $time, $time,
					'is tax payer', 'cs', 'Plátce DPH', $time, $time,
					'is tax payer', 'en', 'Is tax payer', $time, $time,
					'islowvat', 'cs', 'Snížená sazba DPH', $time, $time,
					'islowvat', 'en', 'Is low VAT', $time, $time,
					'issued on', 'cs', 'Datum vystavení', $time, $time,
					'issued on', 'en', 'Issued on', $time, $time,
					'kč', 'cs', 'Kč', $time, $time,
					'kč', 'en', 'Kč', $time, $time,
					'kreditní kartou', 'cs', 'Platební kartou', $time, $time,
					'kreditní kartou', 'en', 'Credit card', $time, $time,
					'platební kartou', 'cs', 'Platební kartou', $time, $time,
					'platební kartou', 'en', 'Credit card', $time, $time,
					'language', 'cs', 'Jazyk', $time, $time,
					'language', 'en', 'Language', $time, $time,
					'last name', 'cs', 'Příjmení', $time, $time,
					'last name', 'en', 'Last name', $time, $time,
					'localized data', 'cs', 'Lokalizována data', $time, $time,
					'localized data', 'en', 'Localized data', $time, $time,
					'logo', 'cs', 'Logo', $time, $time,
					'logo', 'en', 'Logo', $time, $time,
					'master', 'cs', '', $time, $time,
					'master', 'en', '', $time, $time,
					'master (admin mode)', 'cs', '', $time, $time,
					'master (admin mode)', 'en', '', $time, $time,
					'message', 'cs', 'Zpráva', $time, $time,
					'message', 'en', 'Message', $time, $time,
					'modificationdate', 'cs', 'Datum poslední modifikace', $time, $time,
					'modificationdate', 'en', 'Modification date', $time, $time,
					'na dobírku', 'cs', 'Na dobírku', $time, $time,
					'na dobírku', 'en', 'COD', $time, $time,
					'name', 'cs', 'Jméno (Název)', $time, $time,
					'name', 'en', 'Name', $time, $time,
					'new', 'cs', 'Novinka', $time, $time,
					'new', 'en', 'New', $time, $time,
					'news', 'cs', 'Novinka', $time, $time,
					'news', 'en', 'News', $time, $time,
					'news(pl)', 'cs', 'Novinky', $time, $time,
					'news(pl)', 'en', 'News', $time, $time,
					'newsletter active', 'cs', 'Newsletter aktivní', $time, $time,
					'newsletter active', 'en', 'Newsletter active', $time, $time,
					'newsletter confirmed', 'cs', 'Newsletter potvrzen', $time, $time,
					'newsletter confirmed', 'en', 'Newsletter confirmed', $time, $time,
					'newsletterform', 'cs', 'Newsletter formulář', $time, $time,
					'newsletterform', 'en', 'Newsletter form', $time, $time,
					'order', 'cs', 'Objednávka', $time, $time,
					'order', 'en', 'Order', $time, $time,
					'order id', 'cs', 'ID objednávky', $time, $time,
					'order id', 'en', 'Order ID', $time, $time,
					'order info', 'cs', 'Informace o objednávce', $time, $time,
					'order info', 'en', 'Order info', $time, $time,
					'order price', 'cs', 'Cena objednávky', $time, $time,
					'order price', 'en', 'Order price', $time, $time,
					'ordering', 'cs', 'Pořadí', $time, $time,
					'ordering', 'en', 'Ordering', $time, $time,
					'orderproduct', 'cs', 'Produkt', $time, $time,
					'orderproduct', 'en', 'Order product', $time, $time,
					'osobní odběr', 'cs', 'Osobní odběr', $time, $time,
					'osobní odběr', 'en', 'Pick up', $time, $time,
					'out of stock behaviour', 'cs', 'Nákup vyprodaného zboží', $time, $time,
					'out of stock behaviour', 'en', 'Out of stock behaviour', $time, $time,
					'paid', 'cs', 'Zaplaceno', $time, $time,
					'paid', 'en', 'Is paid', $time, $time,
					'paid shadow', 'cs', 'Zaplaceno stín', $time, $time,
					'paid shadow', 'en', 'Paid shadow', $time, $time,
					'parameters', 'cs', 'Parametry', $time, $time,
					'parameters', 'en', 'Parameters', $time, $time,
					'password', 'cs', 'Heslo', $time, $time,
					'password', 'en', 'Password', $time, $time,
					'password reset token', 'cs', 'Token k zresetování hesla', $time, $time,
					'password reset token', 'en', 'Password reset token', $time, $time,
					'path', 'cs', 'Cesta', $time, $time,
					'path', 'en', 'Path', $time, $time,
					'payment cost', 'cs', 'Náklady na platbu', $time, $time,
					'payment cost', 'en', 'Payment cost', $time, $time,
					'payment discount', 'cs', 'Sleva na platbu', $time, $time,
					'payment discount', 'en', 'Payment discount', $time, $time,
					'payment options', 'cs', 'Nastavení platebních možností', $time, $time,
					'payment options', 'en', 'Payment options', $time, $time,
					'payment price', 'cs', 'Cena platby', $time, $time,
					'payment price', 'en', 'Payment price', $time, $time,
					'payment type', 'cs', 'Typ platby', $time, $time,
					'payment type', 'en', 'Payment type', $time, $time,
					'perex', 'cs', 'Perex', $time, $time,
					'perex', 'en', 'Perex', $time, $time,
					'phone', 'cs', 'Telefon', $time, $time,
					'phone', 'en', 'Phone', $time, $time,
					'ppl', 'cs', 'PPL', $time, $time,
					'ppl', 'en', 'PPL', $time, $time,
					'ppl (česko)', 'cs', 'PPL (Česká republika)', $time, $time,
					'ppl (česko)', 'en', 'PPL (Czech republic)', $time, $time,
					'preview image', 'cs', 'Náhledový obrázek', $time, $time,
					'preview image', 'en', 'Preview image', $time, $time,
					'převodem na účet', 'cs', 'Převodem na účet', $time, $time,
					'převodem na účet', 'en', 'Bank transfer', $time, $time,
					'price', 'cs', 'Cena', $time, $time,
					'price', 'en', 'Price', $time, $time,
					'product', 'cs', 'Produkt', $time, $time,
					'product', 'en', 'Product', $time, $time,
					'product data', 'cs', 'Produktová data', $time, $time,
					'product data', 'en', 'Product data', $time, $time,
					'product page limit', 'cs', 'Počet kusů na stránku ve výpise', $time, $time,
					'product page limit', 'en', 'Product page limit', $time, $time,
					'productcolor', 'cs', 'Barva produktu', $time, $time,
					'productcolor', 'en', 'Product color', $time, $time,
					'products', 'cs', 'Produkty', $time, $time,
					'products', 'en', 'Products', $time, $time,
					'products discount', 'cs', 'Sleva za produkty', $time, $time,
					'products discount', 'en', 'Products discount', $time, $time,
					'products or categories', 'cs', 'Produkty nebo kategorie', $time, $time,
					'products or categories', 'en', 'Products or categories', $time, $time,
					'products price', 'cs', 'Cena za produkty', $time, $time,
					'products price', 'en', 'Products price', $time, $time,
					'productsize', 'cs', 'Velikost produktu', $time, $time,
					'productsize', 'en', 'Product size', $time, $time,
					'published', 'cs', 'Zveřejněno', $time, $time,
					'published', 'en', 'Published', $time, $time,
					'reusable', 'cs', 'Znovupoužitelnost', $time, $time,
					'reusable', 'en', 'Reusable', $time, $time,
					'salepromotion', 'cs', 'Globální sleva', $time, $time,
					'salepromotion', 'en', 'Sale promotion', $time, $time,
					'sales', 'cs', 'Prodeje', $time, $time,
					'sales', 'en', 'Sales', $time, $time,
					'seo', 'cs', 'SEO', $time, $time,
					'seo', 'en', 'SEO', $time, $time,
					'seo slug', 'cs', 'SEO slug', $time, $time,
					'seo slug', 'en', 'SEO slug', $time, $time,
					'seo description', 'cs', 'SEO popisek', $time, $time,
					'seo description', 'en', 'SEO description', $time, $time,
					'seo keywords', 'cs', 'SEO klíčová slova', $time, $time,
					'seo keywords', 'en', 'SEO keywords', $time, $time,
					'shipping and payment settings', 'cs', 'Nastavení dopravy a platby', $time, $time,
					'shipping and payment settings', 'en', 'Shipping and payment settings', $time, $time,
					'shipping cost', 'cs', 'Náklady na dopravu', $time, $time,
					'shipping cost', 'en', 'Shipping cost', $time, $time,
					'shipping costs options', 'cs', 'Nastavení cen za dopravu', $time, $time,
					'shipping costs options', 'en', 'Shipping cost options', $time, $time,
					'shipping costs options (always in default currency - czk)', 'cs', 'Nastavení cen za dopravu (v Kč)', $time, $time,
					'shipping costs options (always in default currency - czk)', 'en', 'Shipping cost options (in Kč)', $time, $time,
					'shipping discount', 'cs', 'Sleva na dopravu', $time, $time,
					'shipping discount', 'en', 'Shipping discount', $time, $time,
					'shipping discount options', 'cs', 'Nastavení slev na dopravu', $time, $time,
					'shipping discount options', 'en', 'Shipping discount options', $time, $time,
					'shipping options', 'cs', 'Nastavení dopravy', $time, $time,
					'shipping options', 'en', 'Shipping options', $time, $time,
					'shipping price', 'cs', 'Cena dopravy', $time, $time,
					'shipping price', 'en', 'Shipping price', $time, $time,
					'shipping type', 'cs', 'Typ dopravy', $time, $time,
					'shipping type', 'en', 'Shipping type', $time, $time,
					'short description', 'cs', 'Krátký popisek', $time, $time,
					'short description', 'en', 'Short description', $time, $time,
					'show invoice', 'cs', 'Zobrazit fakturu', $time, $time,
					'show invoice', 'en', 'Show invoice', $time, $time,
					'show product variants in lists', 'cs', 'Zobrazovat farební varianty ve výpise', $time, $time,
					'show product variants in lists', 'en', 'Show color variants in lists', $time, $time,
					'simple page', 'cs', 'Jednoduchá stránka', $time, $time,
					'simple page', 'en', 'Simple page', $time, $time,
					'size', 'cs', 'Velikost', $time, $time,
					'size', 'en', 'Size', $time, $time,
					'sizes', 'cs', 'Velikosti', $time, $time,
					'sizes', 'en', 'Sizes', $time, $time,
					'slovensko', 'cs', 'Slovenská republika', $time, $time,
					'slovensko', 'en', 'Slovak republic', $time, $time,
					'slovensko (eur|czk)', 'cs', 'Slovenská republika (v €, pokud není uvedeno jinak)', $time, $time,
					'slovensko (eur|czk)', 'en', 'Slovak republic (in €, if not stated otherwise)', $time, $time,
					'sold count', 'cs', 'Počet prodaných produktů', $time, $time,
					'sold count', 'en', 'Sold count', $time, $time,
					'stamp', 'cs', 'Razítko', $time, $time,
					'stamp', 'en', 'Stamp', $time, $time,
					'statistics settings', 'cs', 'Nastavení statistik', $time, $time,
					'statistics settings', 'en', 'Statistics settings', $time, $time,
					'status', 'cs', 'Stav', $time, $time,
					'status', 'en', 'Status', $time, $time,
					'status shadow', 'cs', 'Stav stín', $time, $time,
					'status shadow', 'en', 'Status shadow', $time, $time,
					'step 1', 'cs', 'Krok 1', $time, $time,
					'step 1', 'en', 'Step 1', $time, $time,
					'step 2', 'cs', 'Krok 2', $time, $time,
					'step 2', 'en', 'Step 2', $time, $time,
					'step 3', 'cs', 'Krok 3', $time, $time,
					'step 3', 'en', 'Step 3', $time, $time,
					'step 4', 'cs', 'Krok 4', $time, $time,
					'step 4', 'en', 'Step 4', $time, $time,
					'street', 'cs', 'Ulice', $time, $time,
					'street', 'en', 'Street', $time, $time,
					'tax payer', 'cs', 'Plátce DPH', $time, $time,
					'tax payer', 'en', 'Tax payer', $time, $time,
					'tax settings', 'cs', 'Nastavení daně', $time, $time,
					'tax settings', 'en', 'Tax settings', $time, $time,
					'title', 'cs', 'Název', $time, $time,
					'title', 'en', 'Title', $time, $time,
					'tracking number', 'cs', 'Sledovací číslo', $time, $time,
					'tracking number', 'en', 'Tracking number', $time, $time,
					'úloženka', 'cs', 'Úloženka', $time, $time,
					'úloženka', 'en', 'Úloženka ', $time, $time,
					'ulozenka address', 'cs', 'Výdejní místo Úloženka', $time, $time,
					'ulozenka address', 'en', 'Úloženka address', $time, $time,
					'used', 'cs', 'Použito', $time, $time,
					'used', 'en', 'Used', $time, $time,
					'user', 'cs', 'Uživatel', $time, $time,
					'user', 'en', 'User', $time, $time,
					'users', 'cs', 'Uživatelé', $time, $time,
					'users', 'en', 'Users', $time, $time,
					'variant attributes', 'cs', 'Atributy varianty', $time, $time,
					'variant attributes', 'en', 'Variant attributes', $time, $time,
					'variant attribute', 'cs', 'Atribut varianty', $time, $time,
					'variant attribute', 'en', 'Variant attribute', $time, $time,
					'variant data', 'cs', 'Data varianty', $time, $time,
					'variant data', 'en', 'Variant data', $time, $time,
					'variant name', 'cs', 'Název varianty', $time, $time,
					'variant name', 'en', 'Variant name', $time, $time,
					'vat', 'cs', 'DPH', $time, $time,
					'vat', 'en', 'VAT', $time, $time,
					'vat high', 'cs', 'Vyšší sazba DPH v %', $time, $time,
					'vat high', 'en', 'VAT high', $time, $time,
					'vat low', 'cs', 'Snížená sazba DPH v %', $time, $time,
					'vat low', 'en', 'VAT low', $time, $time,
					'zip', 'cs', 'PSČ', $time, $time,
					'zip', 'en', 'ZIP', $time, $time,
					'zip code', 'cs', 'PSČ', $time, $time,
					'zip code', 'en', 'ZIP code', $time, $time
				)
			),
			'website_settings' => array(
				'schema' => array('id', 'name', 'type', 'data', 'siteId', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'frontendLanguages', 'text', 'cs', 0, $time, $time
				)
			)
		);

		foreach($dbExtension as $table => $struct) {
			$q = '(?'.str_repeat(',?', count($struct['schema']) - 1).')';
			$rowCount = count($struct['data']) / count($struct['schema']);
			$stmt = $this->db->prepare(vsprintf('INSERT INTO `%s` (%s) VALUES %s', array(
				$table,
				'`'.implode('`,`', $struct['schema']).'`',
				$q.str_repeat(','.$q, $rowCount - 1)
			)));
			$stmt->execute($struct['data']);
		}
	}
}
