<?
	$locale = $this->order->getCurrency();
	$currency = $this->currencyModel->createFrozenCurrency($locale);
	$discount = min(array($this->order->getProductsPrice(), $this->order->getProductsDiscount())) + $this->order->getShippingDiscount() + $this->order->getPaymentDiscount();
	$paymentType = $this->order->getPaymentType();
?>

<div class="col-md-12">

	<h1>Košík - Rekapitulace</h1>
	<hr>

	<div class="row-fluid">
		<div class="well">
			<h3>Děkujeme za nákup,</h3>
			<p>Vaše objednávka byla úspěšně vytvořena. Informace o objednávce sme Vám zaslali na Váš email <b><?=$this->order->getFEmail();?></b>. Na daný email Vám budeme zasílat také informace o změnách stavu objednávky.</p>
			<?if(\Zend_Auth::getInstance()->hasIdentity()):?>
				<p>Veškeré informace o Vašich objednávkach naleznete také ve Vašem účtu <a href="<?=$this->docUrl('/cs/ucet/objednavky');?>">v přehledu objednávek</a>.</p>
			<?endif;?>
			<?if($paymentType == \Website\Model\OrderManager::PAYMENT_BANK_TRANSFER):?>
				<h3>Platební informace k platbě bankovým převodem</h3>
				<ul>
					<?
						$settings = \Website\Tool\Utils::getEshopSettings();
					?>
					<li>Číslo účtu: <strong><?=$settings->getSupplierAccountNumber();?></strong></li>
					<li>Variabilní symbol: <strong><?=$this->order->getOrderId();?></strong></li>
					<li>Suma k zaplacení: <strong><?=$this->currencyModel->localizeCurrency($this->order->getFinalPrice(), $currency);?></strong></li>
				</ul>
			<?endif;?>
			<h3>Produkty</h3>
			<table class="table table-striped">
				<thead>
					<tr>
						<th>Název</th>
						<th>Cena s DPH</th>
						<th>Počet ks</th>
						<th>Celkem</th>
					</tr>
				</thead>
				<tbody>
					<?foreach($this->order->getProducts() as $product):?>
						<?
							$productObject = $product->getProduct();
						?>
						<tr>
							<td><?=($productObject instanceof \Website\Model\Product) ? $productObject->getVariantName($this->language) : '';?></td>
							<td><?=$this->currencyModel->localizeCurrency($product->getPrice(), $currency);?></td>
							<td><?=$product->getCount();?></td>
							<td><?=$this->currencyModel->localizeCurrency($product->getPrice() * $product->getCount(), $currency);?></td>
						</tr>	
					<?endforeach;?>
					<?if($this->order->getBaseShippingPrice()):?>
						<tr>
							<td><strong><?=$this->translate('label_shipping');?></strong><br><?=$this->translate('label_'.$this->order->getShippingType());?></td>
							<td></td>
							<td></td>
							<td><?=$this->currencyModel->localizeCurrency($this->order->getBaseShippingPrice(), $currency);?></td>
						</tr>
					<?endif;?>
					<?if($this->order->getBasePaymentPrice()):?>
						<tr>
							<td><strong><?=$this->translate('label_payment');?></strong><br><?=$this->translate('label_'.$this->order->getPaymentType());?></td>
							<td></td>
							<td></td>
							<td><?=$this->currencyModel->localizeCurrency($this->order->getBasePaymentPrice(), $currency);?></td>
						</tr>
					<?endif;?>
					<?if($discount):?>
						<tr>
							<td><strong><?=$this->translate('label_discount');?></strong></td>
							<td></td>
							<td></td>
							<td><?='-'.$this->currencyModel->localizeCurrency($discount, $currency);?></td>
						</tr>
					<?endif;?>
				</tbody>
				<tfoot>
					<tr>
						<th>Celkem</th>
						<th></th>
						<th></th>
						<th><?=$this->currencyModel->localizeCurrency($this->order->getFinalPrice(), $currency);?></th>
					</tr>
				</tfoot>
			</table>

			<?
				$info = get_object_vars($this->order);
			?>

			<h3>Fakturační údaje</h3>
			<p><?=$this->translate('label_full_name').': <strong>'.$info['fFirstName'].' '.$info['fLastName'];?></strong></p>
			<p><?=$this->translate('label_email').': <strong>'.$info['fEmail'];?></strong></p>
			<p><?=$this->translate('label_phone').': <strong>'.$info['fPhone'];?></strong></p>
			<p><?=$this->translate('label_street').': <strong>'.$info['fStreet'];?></strong></p>
			<p><?=$this->translate('label_city').': <strong>'.$info['fCity'];?></strong></p>
			<p><?=$this->translate('label_zip_code').': <strong>'.$info['fZipCode'];?></strong></p>
			<?if(!empty($info['fCompany'])):?>
				<p><?=$this->translate('label_company').': <strong>'.$info['fCompany'];?></strong></p>
			<?endif;?>
			<?if(!empty($info['fIco'])):?>
				<p><?=$this->translate('label_ic').': <strong>'.$info['fIco'];?></strong></p>
			<?endif;?>
			<?if(!empty($info['fDic'])):?>
				<p><?=$this->translate('label_dic').': <strong>'.$info['fDic'];?></strong></p>
			<?endif;?>
			<p><?=$this->translate('label_country').': <strong>'.$this->translate('label_country'.$this->cart->getOrder()->country);?></strong></p>
					
			<?if(!empty($info['dStreet'])):?>
				<fieldset>
					<legend>Dodací adresa</legend>
				</fieldset>
				<?if(!empty($info['dCompany'])):?>
					<p><?=$this->translate('label_company').': <strong>'.$info['dCompany'];?></strong></p>
				<?endif;?>
				<p><?=$this->translate('label_full_name').': <strong>'.$info['dFirstName'].' '.$info['dLastName'];?></strong></p>
				<p><?=$this->translate('label_street').': <strong>'.$info['dStreet'];?></strong></p>
				<p><?=$this->translate('label_city').': <strong>'.$info['dCity'];?></strong></p>
				<p><?=$this->translate('label_zipCode').': <strong>'.$info['dZipCode'];?></strong></p>
			<?endif;?>

			<?if(!empty($info['message'])):?>
				<fieldset>
					<legend>Poznámka</legend>
				</fieldset>
				<p><?=$info['message'];?></p>
				<br>
			<?endif;?>
		</div>
	</div>
	<?if($this->quickRegistrationForm):?>
		<?=$this->render('snippet/quick-registration-form.php');?>
	<?endif;?>
</div>

<?$this->layout()->setLayout('standard');?>
