<?
/**
 * @var \Pimcore\Templating\PhpEngine $this
 * @var \Pimcore\Templating\GlobalVariables $app
 */

$templateCache = $this->cache($this->breadcrumbsCacheKey);
$cached = (!\Pimcore\Tool::isFrontentRequestByAdmin()) ? $templateCache->start() : null;

if(!$cached) {
	$breadcrumbsNavigation = null;

	// get the document which should be used to start in navigation | default home
	$navStartNode = $this->document->getProperty("navigationRoot");
	if(!$navStartNode instanceof \Pimcore\Model\Document\Page) {
		$navStartNode = \Pimcore\Model\Document\Page::getById(1);
	}

	if ($this->document instanceof \Pimcore\Model\Document\Page) {
		$navigation = $this->navigation()->buildNavigation($this->document, $navStartNode);
		$activePages = $navigation->findAllBy('active', true);
		if (!empty($activePages)) {
			$breadcrumbsNavigation = $navigation;
		}
	}

	//extend navigation container for breadcrumbs
	if ($breadcrumbsNavigation && !empty($this->addToBreadcrumbs->pages)) {
		$tmp = $breadcrumbsNavigation->findAllBy('active', true);
		end($tmp);
		/* @var $deepestActive \Pimcore\Navigation\Page\Document */
		$deepestActive = current($tmp);
		foreach ($this->addToBreadcrumbs->pages as $key => $page) {
			${'page_'.$key} = \Pimcore\Navigation\Page\Document::factory([
				'label' => $page['label'],
				'title' => $page['label'],
				'uri' => $page['url'],
				'active' => true,
			]);
			$deepestActive->addPage(${'page_'.$key});
			$deepestActive = ${'page_'.$key};
		}
	}
	if ($breadcrumbsNavigation !== null) {
		// home document (ID 1) is not automatically added to the navigation
		if ($navStartNode->getId() === 1) {
			$homepage = \Pimcore\Navigation\Page\Document::factory([
				'order' => -1,
				'uri' => '/',
				'label' => $navStartNode->getProperty('navigation_name'),
				'title' => $navStartNode->getProperty('navigation_title'),
				'active' => true
			]);
			$tmp = $breadcrumbsNavigation->findAllBy('active', true);
			$homepage->addPage(current($tmp));
			$breadcrumbsNavigation->addPage($homepage);
		}
		echo $this->navigation()->breadcrumbs()->setLinkLast(false)
			->setSeparator('')->setMinDepth(null)->setPartial('Snippet/breadcrumbsRender.html.php')
			->render($breadcrumbsNavigation);
	}
}

$templateCache->end();
