<?
/**
 * @var \Pimcore\Templating\PhpEngine $this
 * @var \Pimcore\Templating\PhpEngine $view
 * @var \Pimcore\Templating\GlobalVariables $app
 */
?>
<?if($this->getRequest()->get('elastic_document_indexing') === true): // turn off layout?>
	<? $this->slots()->output('_content'); ?>
<?else:?>
<!DOCTYPE html>
<!--[if lt IE 8 ]><html lang="<?= $this->language; ?>" class="no-js ie ie7"> <![endif]-->
<!--[if lt IE 9 ]><html lang="<?= $this->language; ?>" class="no-js ie ie8"> <![endif]-->
<!--[if lt IE 10 ]><html lang="<?= $this->language; ?>" class="no-js ie ie9"> <![endif]-->
<!--[if (gte IE 10)|!(IE)]><!--><html lang="<?= $this->language; ?>" class="no-js"> <!--<![endif]-->
	<head>
		<!-- META -->
		<?=$this->template('Snippet/meta.html.php'); ?>

		<!-- CSS -->
		<?=$this->headLink()
			->appendStylesheet('/static/css/bootstrap.css', 'screen')
			->appendStylesheet('/static/css/only-for-bootstrap.css', 'screen')
			->appendStylesheet('/static/css/jquery.fancybox.css', 'screen');
		?>
	</head>
	<body<?if ($this->editmode) echo ' class="administration"'; ?>>
		<div id="flash-messages">
			<?=$this->template('Snippet/flashMessages.html.php'); ?>
		</div>
		<div id="wrap">
			<?=$this->template('Snippet/header.html.php'); ?>

			<div class="container">
				<?=$this->template('Snippet/breadcrumbs.html.php'); ?>
				<? $this->slots()->output('_content'); ?>
			</div>
		</div>
		<?=$this->template('Snippet/footer.html.php'); ?>

		<!-- JS -->
		<?=$this->headScript()
			->appendFile('/static/js/lib/jquery-1.10.2.min.js')
			->appendFile('/static/js/app.lib.min.js')
			->appendFile('/static/js/lib/bootstrap.min.js')
			->appendFile('/static/js/app.script.js');
		?>
		<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
			<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
		<?=$this->inlineScript();?>
		<div class="loader-overlay"><div class="loader-box"><div class="loader"></div></div></div>
	</body>
</html>
<?endif;?>
