<?php

namespace AppBundle\Command;

define('DEPLOYER', true);
define('DEPLOYER_BIN', __FILE__);

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DeploymentSyncCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('deployment:sync')
			->setDescription('Download and setup project from the server')
			->addOption(
				'all', 'a',
				InputOption::VALUE_NONE,
				'Full sync'
			)
			->addOption(
				'db', null,
				InputOption::VALUE_NONE,
				'Sync only DB'
			)
			->addOption(
				'skip', 's',
				InputOption::VALUE_NONE,
				'Skip requirements checks and some confirmation blocks'
			)
			->addOption(
				'commit', 'c',
				InputOption::VALUE_REQUIRED,
				'Commit message'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		require_once __DIR__.'/../../../vendor/deployer/deployer/src/functions.php';
		$console = new \Deployer\Console\Application('Deployer', 'master');
		$deployer = new \Deployer\Deployer($console, $input, $output);
		require __DIR__.'/../Tool/Deployer/recipe.php';
		$deployer->run();
	}
}
