<?php

set('web_name', basename(realpath(__DIR__.'/../../../../')));
set('default_stage', 'vm3_production');

/*
 * local mysql root access using --login-path (MySQL 5.6+)
 * alternatively you can use the export MYSQL_PWD technique (see commented lines below)
 */
env('bin/local/mysql', 'mysql --login-path=deployment');
env('bin/local/mysqldump', 'mysqldump --login-path=deployment');
env('bin/local/mysqladmin', 'mysqladmin --login-path=deployment');
//env('bin/local/mysql', 'export MYSQL_PWD=password; mysql -u username');
//env('bin/local/mysqldump', 'export MYSQL_PWD=password; mysqldump -u username');
//env('bin/local/mysqladmin', 'export MYSQL_PWD=password; mysqladmin -u username');

/*
 * vhosts templates
 */
$vm3VhostConfigTemplate = str_replace('###WEB_NAME###', get('web_name'),
'<VirtualHost *:80>
	ServerName			###WEB_NAME###.cz
	ServerAlias			*.###WEB_NAME###.cz
	ServerAlias			###WEB_NAME###.vm3.portadesign.cz *.###WEB_NAME###.vm3.portadesign.cz

	CustomLog			"/data/hosting/###WEB_NAME###/logs/access_log" combined
	ErrorLog			"/data/hosting/###WEB_NAME###/logs/error_log"
	DocumentRoot		"/data/hosting/###WEB_NAME###/html/web"

	RewriteEngine		On
	# this is needed to pass the auth header correctly - fastcgi environment
	RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization},L]
</VirtualHost>');

/*
 * Remote servers configration examples
 *
 * See http://deployer.org/docs/servers for base options
 *
 * Custom options:
 *
 * {{sudo}}
 *   - means the user has sudo rights without entering password on the server
 * {{hosting_path | project_path}} [required]
 *   {{hosting_path}} - webroot will be created at hosting_path/html/{{web_name}} together with some other vhost related directories
 *   {{project_path}} - instead of hosting_path when you already have a pre-created webroot
 * {{http_user}} [sudo, optional]
 *   - will be set as file owner and the cron task will be set in his name
 * {{user_group}} [sudo, optional]
 *   - will be set as file group
 * {{mysql_db}} [optional]
 *   - if specified, that DB will be used (not created)
 *   - otherwise {{web_name}} DB will be created and used (the mysql user must have the rights to create)
 * {{mysql_user, mysql_password | mysql_login_path}} [optional]
 *   - {{mysql_user}}, {{mysql_password}}
 *   - {{mysql_login_path}} - alternative mysql login method (since mysql 5.6)
 * {{vhosts_path}} [sudo, optional]
 *   - vhost will be created here
 * {{vhosts_config_template}} [required if {{vhosts_path}}]
 *   - vhost config template with some placeholders, see above
 * {{vhost_symlink_path}} [sudo, optional]
 *   - vhost symlink will be created here
 * {{apache_reload_command}} [sudo, optional]
 *   - command to reload apache after certain tasks
 */
server('noSudo_createdDB_createdWebRoot', 'example.com')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('project_path', '')
	->env('mysql_db', '')
	->stage('noSudo_createdDB_createdWebRoot_production');

server('vm3', 'vm3.portadesign.cz')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('sudo', true)
	->env('hosting_path', '/data/hosting')
	->env('user_group', 'portadesign')
	->env('mysql_login_path', 'deployment')
	->env('http_user', 'www-data')
	->env('vhosts_path', '/etc/apache2/sites-available')
	->env('vhosts_symlink_path', '/etc/apache2/sites-enabled')
	->env('vhosts_config_template', $vm3VhostConfigTemplate)
	->env('apache_reload_command', 'service apache2 reload')
	->stage('vm3_production');
