document.addEventListener(pimcore.events.pimcoreReady, (e) => {
	//append tools menu to main toolbar
	Ext.Ajax.request({
		url: '/admin/plugin/backend/is-elastic-search-enabled',
		success: (data) => {
			const res = Ext.decode(data.responseText);
			if(!res.ese) return;

			const menu = new Ext.menu.Menu({
				items: [{
					text: t("plugin_backend_reindex_elastic"),
					iconCls: "pimcore_icon_clear_cache",
					handler: () => {
						Ext.Msg.confirm(t('warning'), t('plugin_backend_this_may_take_a_while'), (btn) => {
							if(!btn == 'yes') return;

							pimcore.globalmanager.get("loadingmask").show();
							Ext.Ajax.request({
								url: '/plugin/backend/reindex-elastic-search',
								success: (response) => {
									pimcore.globalmanager.get("loadingmask").hide();
								},
								failure: () => {
									pimcore.globalmanager.get("loadingmask").hide();
									Ext.MessageBox.alert(t("error"), t("plugin_backend_error_reindexing_elastic"));
								}
							});
						});
					}
				}],
				cls: "pimcore_navigation_flyout"
			});

			const toolbar = pimcore.globalmanager.get("layout_toolbar");
			const searchBtn = Ext.get('pimcore_menu_search');
			if(!searchBtn) return;

			this.navEl = searchBtn.insertSibling('<li id="pimcore_menu_tools" data-menu-tooltip="'+t("plugin_backend_reindex_elastic")+'"><svg style="width:26px;height:26px" viewBox="0 0 48 48"><path class="st0" d="M44.7,11L36,19.6c0,0-2.6,0-5.2-2.6s-2.6-5.2-2.6-5.2l8.7-8.7c-4.9-1.2-10.8,0.4-14.4,4 c-5.4,5.4-0.6,12.3-2,13.7C12.9,28.7,5.1,34.7,4.9,35c-2.3,2.3-2.4,6-0.2,8.2s5.9,2.1,8.2-0.2c0.3-0.3,6.7-8.4,14.2-15.9 c1.4-1.4,8,3.7,13.6-1.8C44.2,21.7,45.9,15.9,44.7,11z M9.4,41.1c-1.4,0-2.5-1.1-2.5-2.5C6.9,37.1,8,36,9.4,36s2.5,1.1,2.5,2.5 S10.8,41.1,9.4,41.1z"/></svg></li>');
			this.navEl.on("mousedown", toolbar.showSubMenu.bind(menu));
		},
		failure: () => {
		}
	});
});
