//https://www.tiny.cloud/docs/tinymce/latest/content-formatting/
//https://www.tiny.cloud/docs/tinymce/latest/available-toolbar-buttons/

const defaultConfig = {
    style_formats: [
        { title: 'Tlačítko - outline', selector: 'a', classes: 'btn btn--outline btn--slide-hover' },
        { title: 'Tlačítko - outline malé', selector: 'a', classes: 'btn btn--small btn--outline btn--slide-hover' },
        { title: 'Tlačítko - plné', selector: 'a', classes: 'btn btn--slide-hover' },
        { title: 'Tlačítko - uvnitř textu', selector: 'a', classes: 'btn btn--inline' },
        { title: 'Seznam - zaškrtnutí', selector: 'ul', classes: 'list-checked' },
        { title: 'Seznam - zaškrtnutí, 2 na řádek', selector: 'ul', classes: 'list-checked list-checked--2' },
    ],
    plugins: 'link anchor image table charmap media code lists wordcount nonbreaking',
    toolbar1: 'cut copy paste pastetext | undo redo | link unlink anchor | image table charmap media nonbreaking | superscript | code',
    toolbar2: 'styles | blocks | alignleft aligncenter alignright | bold italic removeformat | bullist numlist | blockquote',
    iframe_template_callback: (data) => {
        const width = data.width ?? 400,
            height = data.height ?? 300,
            source = data.source ?? '';

        // data-type="pimcore_video_editable" hotfix to prevent from adding an overlay by pimcore
        return `<div class="video-iframe"><figure>
            <iframe data-type="pimcore_video_editable" width="${width}" height="${height}" src="${source}"></iframe>
            </figure></div>`;
    },
    allow_html_in_named_anchor: true,
    extended_valid_elements: 'a[*]',
};

const setObjectWysiwygConfig = () => {
    if (pimcore.object && pimcore.object.tags) {
        pimcore.object.tags.wysiwyg = pimcore.object.tags.wysiwyg || {};
        pimcore.object.tags.wysiwyg.defaultEditorConfig = defaultConfig;
    }
}

const setDocumentWysiwygConfig = () => {
    if (pimcore.document && pimcore.document.editables) {
        pimcore.document.editables.wysiwyg = pimcore.document.editables.wysiwyg || {};
        pimcore.document.editables.wysiwyg.defaultEditorConfig = defaultConfig;
    }
}

setObjectWysiwygConfig();
setDocumentWysiwygConfig();