<?php declare(strict_types=1);

namespace App\Controller;

use App\Model\DataObject\News;
use Knp\Bundle\PaginatorBundle\Pagination\SlidingPagination;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Component\HttpFoundation\Response;

class NewsController extends BaseController
{
    /*						DOCUMENT ROUTED ACTIONS							*/

    public function newsAction(PaginatorInterface $paginator): Response
    {
        $pageLimit = 4;
        $page = $this->getRequest()->query->getInt('page', 1);

        // news pagination
        $list = new News\Listing();
        $list->setDefaultParameters();

        // paginator
        $paginator = $paginator->paginate(
            $list,
            $page,
            $pageLimit
        );
        $paginationData = $paginator instanceof SlidingPagination ? $paginator->getPaginationData() : [];
        $paginationData['urlprefix'] = $this->document?->getFullPath() . '?page=';

        return $this->render('news/news.html.twig', [
            'news' => $paginator,
            'paginationData' => $paginationData,
        ]);
    }

    /* 						STATIC-ROUTE ROUTED ACTIONS						 */

    public function newsDetailAction(string $id): Response
    {
        $news = News::getById($id);
        if (!$news instanceof News) {
            throw $this->createNotFoundException('News not found');
        }

        // more news
        $newsList = new News\Listing();
        $newsList->setDefaultParameters();
        $newsList->setLimit(2);
        $newsList->excludeIds([$news->getId()]);

        // seo
        $this->headTitle->set($news->getName());
        if ($news->getSeoDescription()) {
            $this->headMeta->setName('description', $news->getSeoDescription());
        }

        return $this->render('news/newsDetail.html.twig', [
            'news' => $news,
            'moreNews' => $newsList->getObjects()
        ]);
    }
}
