<?php declare(strict_types=1);

namespace App\EventSubscriber;

use Pimcore\Bundle\GoogleMarketingBundle\Event\GoogleAnalyticsEvents;
use Pimcore\Bundle\GoogleMarketingBundle\Event\GoogleTagManagerEvents;
use Pimcore\Bundle\GoogleMarketingBundle\Model\Event\TagManager\CodeEvent;
use Pimcore\Bundle\GoogleMarketingBundle\Model\Event\TrackingDataEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class GoogleTrackingCodeSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            GoogleAnalyticsEvents::CODE_TRACKING_DATA => 'onGATrackingData',
            GoogleTagManagerEvents::CODE_HEAD => 'onGTMHead',
            GoogleTagManagerEvents::CODE_BODY => 'onGTMBody',
        ];
    }

    public function onGATrackingData(TrackingDataEvent $event): void
    {
        $event->setTemplate('snippet/marketing/ga.html.twig');
    }

    public function onGTMHead(CodeEvent $event): void
    {
        $event->setTemplate('snippet/marketing/gtmHead.html.twig');
    }

    public function onGTMBody(CodeEvent $event): void
    {
        $event->setTemplate('snippet/marketing/gtmBody.html.twig');
    }
}
