<?php declare(strict_types=1);

namespace App\EventSubscriber;

use Pimcore\Event\SystemEvents;
use Pimcore\File;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\EventDispatcher\GenericEvent;

class KeyValidationSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            SystemEvents::SERVICE_PRE_GET_VALID_KEY => 'onPreGetValidKey',
        ];
    }

    public function onPreGetValidKey(GenericEvent $event): void
    {
        $event->setArgument('key', File::getValidFilename($event->getArgument('key')));
    }
}
