<?php declare(strict_types=1);

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\Email;
use Symfony\Component\Validator\Constraints\NotBlank;

class PasswordResetFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email', EmailType::class, [
                'label' => 'label_email',
                'required' => true,
                'constraints' => [
                    new NotBlank(['message' => 'msg_empty_field']),
                    new Email(['message' => 'msg_invalid_email']),
                ],
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'label_reset_password',
            ]);
    }
}
