<?php declare(strict_types=1);

namespace App\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

final class Version20240918143200 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Import Pimcore admin custom translations';
    }

    public function up(Schema $schema): void
    {
        foreach ($this->getTranslations() as $key => $data) {
            foreach ($data as $language => $translation) {
                $this->addSql("
                    INSERT IGNORE INTO translations_admin
                    (`key`, `language`, `text`, `creationDate`, `modificationDate`)
                    VALUES ('$key', '$language', '$translation', UNIX_TIMESTAMP(), UNIX_TIMESTAMP())
                ");
            }
        }
    }

    public function down(Schema $schema): void
    {
    }

    /**
     * @return array<string, array<string, string>>
     */
    private function getTranslations(): array
    {
        return [
            'Activation code' => [
                'cs' => 'Aktivační kód',
                'en' => 'Activation code',
            ],
            'City' => [
                'cs' => 'Město',
                'en' => 'City',
            ],
            'Company' => [
                'cs' => 'Společnost',
                'en' => 'Company',
            ],
            'Contact' => [
                'cs' => 'Kontakt',
                'en' => 'Contact',
            ],
            'ContactForm' => [
                'cs' => 'Kontaktní formulář',
                'en' => 'Contact form',
            ],
            'Content' => [
                'cs' => 'Obsah',
                'en' => 'Content',
            ],
            'Creation date' => [
                'cs' => 'Datum vytvoření',
                'en' => 'Creation date',
            ],
            'Czech' => [
                'cs' => 'Čeština',
                'en' => 'Czech',
            ],
            'DIC' => [
                'cs' => 'DIČ',
                'en' => 'DIČ',
            ],
            'Email' => [
                'cs' => 'E-mail',
                'en' => 'E-mail',
            ],
            'First name' => [
                'cs' => 'Jméno',
                'en' => 'First name',
            ],
            'Generate' => [
                'cs' => 'Generovat',
                'en' => 'Generate',
            ],
            'IC' => [
                'cs' => 'IČ',
                'en' => 'IČ',
            ],
            'Language' => [
                'cs' => 'Jazyk',
                'en' => 'Language',
            ],
            'Last name' => [
                'cs' => 'Příjmení',
                'en' => 'Last name',
            ],
            'Message' => [
                'cs' => 'Zpráva',
                'en' => 'Message',
            ],
            'Name' => [
                'cs' => 'Jméno (Název)',
                'en' => 'Name',
            ],
            'News' => [
                'cs' => 'Novinka',
                'en' => 'News',
            ],
            'News(pl)' => [
                'cs' => 'Novinky',
                'en' => 'News',
            ],
            'Newsletter' => [
                'cs' => 'Newsletter',
                'en' => 'Newsletter',
            ],
            'NewsletterForm' => [
                'cs' => 'Newsletter formulář',
                'en' => 'Newsletter form',
            ],
            'Password reset token' => [
                'cs' => 'Token k resetování hesla',
                'en' => 'Password reset token',
            ],
            'Perex' => [
                'cs' => 'Perex',
                'en' => 'Perex',
            ],
            'Phone' => [
                'cs' => 'Telefon',
                'en' => 'Phone',
            ],
            'Preview image' => [
                'cs' => 'Náhledový obrázek',
                'en' => 'Preview image',
            ],
            'Seo description' => [
                'cs' => 'SEO popisek',
                'en' => 'SEO description',
            ],
            'Simple page' => [
                'cs' => 'Jednoduchá stránka',
                'en' => 'Simple page',
            ],
            'Street' => [
                'cs' => 'Ulice',
                'en' => 'Street',
            ],
            'Url' => [
                'cs' => 'URL',
                'en' => 'URL',
            ],
            'User' => [
                'cs' => 'Uživatel',
                'en' => 'User',
            ],
            'Users' => [
                'cs' => 'Uživatelé',
                'en' => 'Users',
            ],
            'Zip code' => [
                'cs' => 'PSČ',
                'en' => 'Zip code',
            ],
            'area_email' => [
                'cs' => 'E-mail',
                'en' => 'E-mail',
            ],
            'area_gallery' => [
                'cs' => 'Galerie',
                'en' => 'Gallery',
            ],
            'area_textblock' => [
                'cs' => 'Text',
                'en' => 'Text block',
            ],
            'base_page' => [
                'cs' => 'Base Page',
                'en' => 'Base Page',
            ],
            'classname' => [
                'cs' => 'Název třídy',
                'en' => 'Class name',
            ],
            'creationdate' => [
                'cs' => 'Datum vytvoření',
                'en' => 'Creation date',
            ],
            'filename' => [
                'cs' => 'Název souboru (složky)',
                'en' => 'Filename',
            ],
            'firstname' => [
                'cs' => 'Jméno',
                'en' => 'First name',
            ],
            'fullpath' => [
                'cs' => 'Cesta',
                'en' => 'Full path',
            ],
            'gender' => [
                'cs' => 'Pohlaví',
                'en' => 'Gender',
            ],
            'lastname' => [
                'cs' => 'Příjmení',
                'en' => 'Last name',
            ],
            'newsletter active' => [
                'cs' => 'Newsletter aktivní',
                'en' => 'Newsletter active',
            ],
            'newsletter confirmed' => [
                'cs' => 'Newsletter potvrzen',
                'en' => 'Newsletter confirmed',
            ],
            'newsletterActive' => [
                'cs' => 'Newsletter aktivní',
                'en' => 'Newsletter active',
            ],
            'newsletterConfirmed' => [
                'cs' => 'Newsletter potvrzen',
                'en' => 'Newsletter confirmed',
            ],
            'unsubscribe code' => [
                'cs' => 'Kód k odhlášení z newsletteru',
                'en' => 'Unsubscribe code',
            ],
        ];
    }
}
