<?php declare(strict_types=1);

namespace App\Model\DataObject\News;

use Pimcore\Model\DataObject;

class Listing extends DataObject\News\Listing
{
    public function setDefaultParameters(): static
    {
        $this->setOrder(['desc']);
        $this->setOrderKey(['createdOn']);

        return $this;
    }

    public function excludeIds(array $ids): static
    {
        $this->addConditionParam('id NOT IN (:ids)', ['ids' => $ids]);

        return $this;
    }

    public function whereKey(string $key): static
    {
        $this->addConditionParam('`key` = ?', $key);

        return $this;
    }
}
