<?php

namespace App\Model\Document;

use App\Model\ElasticObjectFulltextInterface;
use App\Tool\Utils;
use Pimcore\Model\Document;

class Page extends Document\Page implements ElasticObjectFulltextInterface
{
    use \App\Model\ElasticTrait;

    public function save(array $parameters = []): static
    {
        $page = parent::save($parameters);

        if (Utils::elasticSearchEnabled()) {
            $this->elasticSearchUpdateFulltext();
        }

        return $page;
    }

    public function delete(): void
    {
        if (Utils::elasticSearchEnabled()) {
            $this->elasticSearchDeleteFulltext();
        }

        parent::delete();
    }

    /* 								For elastic search							*/

    public function elasticSearchLoadFulltext(string $lang): array
    {
        $data = array_merge($this->getElasticBaseData(), [
            'path' => Utils::docUrl($this->getRealFullPath(), $lang),
            'title' => $this->getTitle(),
            'description' => $this->getDescription(),
            'content' => ($this->getPublished())
                ? $this->normalizeElasticText(Document\Service::render(
                    $this,
                    [
                        'elastic_document_indexing' => true,
                    ],
                    false // this does not work :( so we have to have a condition in layout
                ))
                : '',
        ]);

        return $data;
    }
}
