<?php declare(strict_types=1);

namespace App\OptionsProvider;

use App\Service\LanguageService;
use Pimcore\Bundle\ApplicationLoggerBundle\ApplicationLogger;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\DynamicOptionsProvider\SelectOptionsProviderInterface;
use Pimcore\Translation\Translator;

abstract class OptionsProvider implements SelectOptionsProviderInterface
{
    public function __construct(protected ApplicationLogger $applicationLogger, protected Translator $translator, protected LanguageService $languageService)
    {
    }

    /**
     * @param array<string, mixed> $context
     */
    public function getDefaultValue(array $context, Data $fieldDefinition): ?string
    {
        return null;
    }

    /**
     * @param array<string, mixed> $context
     */
    public function hasStaticOptions(array $context, Data $fieldDefinition): bool
    {
        return true;
    }

    /**
     * Maps objects to array with options for admin selects
     */
    protected function objectsToOptions(array $objects, string $language): array
    {
        $options = [];
        foreach ($objects as $object) {
            $options[] = ['key' => $object->getName($language), 'value' => (string) $object->getId()];
        }

        return $options;
    }

    /**
     * Maps simple key-value array to options array in format for admin selects
     */
    protected function arrayToOptions(array $array): array
    {
        $options = [];
        foreach ($array as $key => $item) {
            $options[] = ['key' => $item, 'value' => (string) $key];
        }

        return $options;
    }
}
