<?php declare(strict_types=1);

namespace App\Service;

use Pimcore\Tool;

class LanguageService
{
    const CZECH = 'cs';
    const ENGLISH = 'en';

    /**
     * @throws \RuntimeException
     */
    public function getDefaultLanguage(): string
    {
        $language = Tool::getDefaultLanguage();

        if (empty($language)) {
            throw new \RuntimeException('No default language set, please set it in the system settings');
        }

        return $language;
    }

    /**
     * @return array<string>
     */
    public function getValidLanguages(): array
    {
        return Tool::getValidLanguages();
    }

    /**
     * @return array<string>
     *
     * @throws \RuntimeException
     */
    public function getLanguagesWithoutDefault(): array
    {
        return array_diff($this->getValidLanguages(), [$this->getDefaultLanguage()]);
    }

    public function checkLanguage(string $language): bool
    {
        $supportedLanguages = $this->getValidLanguages();

        return in_array($language, $supportedLanguages);
    }

    public function getLanguageFromLocale(string $locale): string
    {
        $start = 0;
        $end = 2;

        $fromLocale = substr($locale, $start, $end);

        $this->checkLanguage($fromLocale);

        return $fromLocale;
    }
}
