<?php

namespace App\Command;

use App\Tool;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ElasticReindexCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('elastic:reindex')
			->setDescription('Reindex elastic search indices')
			->addOption(
				'fulltext', 'f',
				InputOption::VALUE_OPTIONAL,
				'Restrict fulltext indices with a comma separated class list',
				'all'
			)
			->addOption(
				'objects', 'o',
				InputOption::VALUE_OPTIONAL,
				'Restrict objects indices with a comma separated class list',
				'all'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$fulltext = $input->getOption('fulltext');
		$objects = $input->getOption('objects');
		if (!$fulltext && !$objects) {
			$fulltext = true;
			$objects = true;
		}
		if ('all' == $fulltext) {
			$fulltext = true;
		}
		if ('all' == $objects) {
			$objects = true;
		}
		Tool\ElasticSearch::setOutputInterface($output);
		Tool\ElasticSearch::updateIndicesAndReindexContent($fulltext, $objects);
		return AbstractCommand::SUCCESS;
	}
}
