<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
//use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Email;

class LoginFormType extends AbstractType
{
	/**
	 * {@inheritdoc}
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		$builder
			->add('email', EmailType::class, [
				'label' => 'label_email',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
					new Email(['message' => 'msg_invalid_email']),
				],
			])
			->add('password', PasswordType::class, [
				'label' => 'label_password',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('target', HiddenType::class, [
				'required' => true,
			])
			/*
			->add('rememberMe', CheckboxType::class, [
				'label' => 'label_remember_me',
				'required' => false,
			])
			 */
			->add('submit', SubmitType::class, [
				'label' => 'label_login',
			]);
	}

	/**
	 * {@inheritdoc}
	 */
	public function getBlockPrefix()
	{
		// we need to set this to an empty string as we want _username as input name
		// instead of login_form[_username] to work with the form authenticator out
		// of the box
		return '';
	}
}
