<?php

namespace App\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class PaginationExtension extends AbstractExtension
{
	/**
	 * @return array|TwigFunction[]
	 */
	public function getFunctions()
	{
		return [
			new TwigFunction('pagination', [$this, 'getPagination']),
		];
	}

	/**
	 * Builds and returns an array of pagination variables.
	 */
	public function getPagination(array $pagination): array
	{
		$urlPrevious = $urlFirst = $urlNext = $urlLast = 'javascript:void(0)';
		if (isset($pagination['previous']) && !isset($pagination['ajax'])) {
			$urlFirst = $pagination['urlprefix'] . $pagination['first'];
			$urlPrevious = $pagination['urlprefix'] . $pagination['previous'];
		}
		if (isset($pagination['next']) && !isset($pagination['ajax'])) {
			$urlNext = $pagination['urlprefix'] . $pagination['next'];
			$urlLast = $pagination['urlprefix'] . $pagination['last'];
		}
		$listBoundaryLength = 3;
		$listStart = max([1, $pagination['current'] - $listBoundaryLength]);
		$listEnd = min([$pagination['last'], $listStart + $listBoundaryLength * 2]);
		$listStart = max([1, $listEnd - $listBoundaryLength * 2]);
		// Extend the pagination with new properties.
		$pagination['isAjax'] = isset($pagination['ajax']);
		$pagination['urlPrevious'] = $urlPrevious;
		$pagination['urlFirst'] = $urlFirst;
		$pagination['urlNext'] = $urlNext;
		$pagination['urlLast'] = $urlLast;
		$pagination['listBoundaryLength'] = $listBoundaryLength;
		$pagination['listStart'] = $listStart;
		$pagination['listEnd'] = $listEnd;

		return $pagination;
	}
}
