<?php

namespace App\View\Helper;

use Pimcore\Templating\Helper\TemplatingEngineAwareHelperInterface;
use Symfony\Component\Templating\Helper\Helper;

class Editable extends Helper implements TemplatingEngineAwareHelperInterface
{
	use \Pimcore\Templating\Helper\Traits\TemplatingEngineAwareHelperTrait;

	/**
	 * {@inheritdoc}
	 */
	public function getName()
	{
		return 'editable';
	}

	/**
	 * @param string $key
	 * @param string $method input, wysiwyg, image...
	 * @param array  $config
	 *
	 * @return document editable
	 */
	public function __invoke($key, $method, $config = [])
	{
		$defaultConfigs = [
			'input' => [
				'width' => 0,
				'htmlspecialchars' => true,
			],
			'numeric' => [
				'width' => 0,
				'minValue' => 0,
			],
			'textarea' => [
				'width' => 0,
				'height' => 100,
				'nl2br' => true,
				'htmlspecialchars' => true,
			],
			'wysiwyg' => [
				'width' => 0,
				'height' => 100,
				'inline' => true,
				'enterMode' => 1,
				'customConfig' => '/admin/js/cke_config_document_loader.js',
			],
			'image' => [
				'hidetext' => true,
				'reload' => false,
				'thumbnail' => 'AdminFallback',
				'uploadPath' => '/dokumenty',
			],
			'multihref' => [
				'width' => 0,
				'uploadPath' => '/dokumenty',
				'thumbnail' => null,
			],
			'href' => [
				'width' => 0,
			],
			'checkbox' => [
				'reload' => false,
			],
			'date' => [
				'format' => 'd.m.Y',
				'startDay' => 1,
			],
			'select' => [
				'reload' => false,
				'store' => [['dummy', 'dummy']],
			],
			'table' => [
				'width' => 0,
				'defaults' => ['cols' => 1, 'rows' => 1, 'data' => [['dummy']]],
			],
			'multiselect' => [
				'width' => 0,
				'store' => [['dummy', 'dummy']],
			],
		];
		if ('image' == $method && $this->templatingEngine->editmode) {
			$defaultConfigs['image']['width'] = 0;
		}

		if (array_key_exists($method, $defaultConfigs)) {
			return $this->templatingEngine->{$method}(
				$key,
				$this->replaceConfigDefaults($defaultConfigs[$method], $config)
			);
		}
	}

	/**
	 * @param array $defaultConfig
	 * @param array $config
	 *
	 * @return array
	 */
	private function replaceConfigDefaults($defaultConfig, $config = [])
	{
		// replace existing keys from $config or global $this->templatingEngine
		foreach (array_keys($defaultConfig) as $key) {
			if (isset($config[$key])) {
				if ($config[$key]) {
					$defaultConfig[$key] = $config[$key];
				} else {
					unset($defaultConfig[$key]);
				}
			} elseif (isset($this->templatingEngine->$key)) {
				if ($this->templatingEngine->$key) {
					$defaultConfig[$key] = $this->templatingEngine->$key;
				} else {
					unset($defaultConfig[$key]);
				}
			}
		}

		// add new keys from $config
		foreach ($config as $key => $value) {
			if (!isset($defaultConfig[$key])) {
				$defaultConfig[$key] = $value;
			}
		}

		return $defaultConfig;
	}
}
