const Encore = require('@symfony/webpack-encore')
const StyleLintPlugin = require('stylelint-webpack-plugin')
const PurgeCssPlugin = require('purgecss-webpack-plugin')
const ESLintPlugin = require('eslint-webpack-plugin')
const glob = require('glob-all')
const path = require('path')

const outputPath = './public/build/'
const publicPath = '/build'

// Production config
const EncoreConfig = Encore
  .setOutputPath(outputPath)
  .setPublicPath(publicPath)

  .addEntry('scripts', ['./assets/js/scripts.js'])
  .addStyleEntry('styles', './assets/styles/styles.scss')

  .configureDevServerOptions(options => {
    options.allowedHosts = 'all';
  })

  .configureFriendlyErrorsPlugin()
  .enableSourceMaps(!Encore.isProduction())
  .enableVersioning(Encore.isProduction())
  .splitEntryChunks()
  .enableSingleRuntimeChunk()
  .addPlugin(new ESLintPlugin({ fix: true }))

  .configureImageRule({
    // tell Webpack it should consider inlining
    type: 'asset',
    //maxSize: 4 * 1024, // 4 kb - the default is 8kb
  })
  .enableSassLoader(() => {}, { resolveUrlLoader: false })

if (Encore.isProduction()) {
  EncoreConfig
    .cleanupOutputBeforeBuild()
    .addPlugin(new StyleLintPlugin({
      lintDirtyModulesOnly: Encore.isProduction(),
      context: './assets/styles',
      emitError: true,
      emitWarning: true,
      quiet: false,
      failOnError: Encore.isProduction()
    }))
    .addPlugin(new PurgeCssPlugin({
      paths: glob.sync([
        path.join(__dirname, 'templates/**/*.html.twig'),
        path.join(__dirname, '!node_modules/**/*'),
        path.join(__dirname, '!vendor/**/*'),
        path.join(__dirname, '!var/**/*'),
        path.join(__dirname, '!public/**/*'),
        path.join(__dirname, '!config/**/*'),
        path.join(__dirname, '!bin/**/*'),
        path.join(__dirname, '!assets/**/*'),
        path.join(__dirname, '!dump/**/*')
      ]),
      safelist: {
        standard: [/^input-loader/, /^body-/, /^table/, /^table-/, /^tr/, /^th/, /^td/, /^form-loader/, /^loader/, /^cc-/, /^numInputWrapper/,
          /^sticky/, /^table/, /^table-/, /^original/, /^gm-/, /^has-/, /^lg-/, /^is-/, /^d-/, /^on/, /^off/, /^toggle-/, /^gm-/, /^marker-/,
          /^has-/, /^not/, /^disabled/, /^required/, /^active/, /^tooltip/, /^js-/, /^icon-/, /^modal/, /^status/, /^gmnoprint/, /^v-/ ]
      },
      variables: true,
      defaultExtractor: (content) => {
        return content.match(/[\w-/:]+(?<!:)/g) || []
      }
    }))
    .enablePostCssLoader()
    .configureBabel(null, {
      includeNodeModules: [
//        'cash-dom'
      ]
    })
    .autoProvidejQuery()
}
const config = EncoreConfig.getWebpackConfig()
config.watchOptions = { ignored: /node_modules/ }

// Export settings and generate files
module.exports = config
