# Pimweb
***
Simple, ready-to-use website skeleton on top of Pimcore 11.x CMS.

## Setup
### Init project
```bash
COMPOSER_MEMORY_LIMIT=-1 composer create-project portabucket/pimweb --prefer-dist --repository-url=https://packages.portadesign.cz . <version>
```
- `<version>` - version of the project, see https://packages.portadesign.cz for available versions
### Docker
1. Clone & run Traefik (https://github.com/portadesign/traefik)
```bash
docker network create traefik
```
2. Edit .env file
- set `APP_NAME` variable, lowercase, no special characters, e.g. "suys"
- set `APP_SECRET` variable

3. Run docker compose
```bash
docker compose up -d
```

### Github private repositories access (optional)
A. Using private key
- Edit `~/.ssh/config` (**on your local machine**)
```text
Host github.com
    HostName github.com
    User git
    IdentityFile ~/.ssh/<private_key>
```
- `<private_key>` - name of the private key file

B. Using external identity agent (e.g. 1Password SSH Agent)
- Edit `~/.ssh/config` (**on your local machine**)
```text
Host *
	IdentityAgent "<path>/agent.sock" # this line is automatically added e.g. by 1Password (settings -> developer -> use the SSH agent)
	
Host github.com
	HostName github.com
	User git
	IdentityFile ~/.ssh/<public_key> # use the public key, private key is loaded by the agent
	IdentitiesOnly yes
```
- `<path>` - path to the agent socket
- `<public_key>` - name of the public key file

## Installation
### Pimcore
1. Install Pimcore
```bash
docker compose exec php-fpm vendor/bin/pimcore-install --mysql-host-socket=db --mysql-username=pimcore --mysql-password=pimcore --mysql-database=pimcore --skip-database-config
```
2. Install Pimcore bundles (required)
```bash
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreAdminBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreApplicationLoggerBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreTinymceBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreSeoBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreSimpleBackendSearchBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreGoogleMarketingBundle
```
3. Install optional Pimcore bundles
```bash
docker compose exec php-fpm bin/console pimcore:bundle:install PimcorePerspectiveEditorBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreCustomReportsBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreStaticRoutesBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreGlossaryBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreNewsletterBundle
docker compose exec php-fpm bin/console pimcore:bundle:install PimcoreFileExplorerBundle
```
4. Migrate database
```bash
docker compose exec php-fpm bin/console doctrine:migrations:migrate --prefix=Pimcore\\Bundle\\CoreBundle
docker compose exec php-fpm bin/console doctrine:migrations:migrate --prefix=App\\Migrations
```
5. Rebuild classes
```bash
docker compose exec php-fpm bin/console pimcore:deployment:classes-rebuild -c -d -n
```
6. Clear cache
```bash
docker compose exec php-fpm bin/console cache:clear
```

## Development
### Dev urls
| Service | URL                                                    |
|---------|--------------------------------------------------------|
| Web     | <APP_NAME>.app.localhost                               |
| Adminer | <APP_NAME>.adminer.localhost                           |
| MailHog | <APP_NAME>.mailhog.localhost                   |
| Traefik | [https://traefik.localhost](https://traefik.localhost) |

### PHPStan
```bash
docker compose exec php-fpm vendor/bin/phpstan --memory-limit=1G
```

### Codeception (tests)
```bash
docker compose exec php-fpm vendor/bin/codecept run
```