<?php declare(strict_types=1);

namespace App\Elasticsearch\Contract;

interface ElasticsearchFulltextInterface extends ElasticsearchElementInterface
{
    /**
     * @return array<string, mixed>
     */
    public function elasticsearchGetFulltextMapping(string $language): array;

    public function elasticsearchRenderContentToFulltextMapping(): bool;

    public function elasticsearchGetFulltextContentTemplateName(): string;

    /**
     * @return array<string, mixed>
     */
    public function elasticsearchGetFulltextContentParameters(): array;
}
