<?php declare(strict_types=1);

namespace App\Elasticsearch\Message;

use App\Enum\Element\Type;

abstract readonly class AbstractFulltextMessage extends AbstractElementMessage
{
    public function __construct(
        private int  $id,
        private Type $type,
    ) {
        parent::__construct($id);
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getType(): Type
    {
        return $this->type;
    }
}
