<?php declare(strict_types=1);

namespace App\Elasticsearch\MessageHandler;

use App\Elasticsearch\Contract\ElasticsearchDataObjectInterface;
use App\Elasticsearch\Message\IndexDataObject;
use App\Elasticsearch\Service\IndexService;
use Pimcore\Bundle\ApplicationLoggerBundle\ApplicationLogger;
use Pimcore\Model\DataObject;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;

#[AsMessageHandler]
readonly class IndexDataObjectHandler
{
    public function __construct(
        private IndexService      $indexService,
        private ApplicationLogger $applicationLogger,
    ) {
    }

    public function __invoke(IndexDataObject $message): void
    {
        $dataObject = DataObject::getById($message->getId());

        if (!$dataObject instanceof ElasticsearchDataObjectInterface) {
            return;
        }

        try {
            $this->indexService->indexDataObject($dataObject);
        } catch (\Throwable $e) {
            /** @var $dataObject DataObject\AbstractObject */
            $this->applicationLogger->logException(
                'Cannot index data for object',
                $e,
                relatedObject: $dataObject,
                component: __METHOD__ . ':' . __LINE__,
            );
        }
    }
}
