<?php declare(strict_types=1);

namespace App\Elasticsearch\Trait;

trait ElasticsearchTrait
{
    private ?array $elasticsearchMapping = null;

    public function getElasticsearchBaseData(): array
    {
        return [
            'id' => (int)parent::getId(),
            'parentId' => (int)parent::getParentId(),
            'published' => (bool)parent::getPublished(),
            'path' => parent::getPath(),
            'key' => parent::getKey(),
            'type' => $this->getClassNameShort(),
        ];
    }

    public function getClassNameShort(): string
    {
        return basename(str_replace('\\', '/', static::class));
    }

    /**
     * @return ?array<string, mixed>
     */
    public function getElasticsearchMapping(): ?array
    {
        return $this->elasticsearchMapping;
    }

    public function elasticsearchRenderContentToFulltextMapping(): bool
    {
        return true;
    }
    
    /**
     * @return array<string, mixed>
     */
    public function elasticsearchGetFulltextContentParameters(): array
    {
        return [];
    }
}
